package com.biz.crm.rawdata.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * @Project crm
 * @PackageName com.biz.crm.rawdata.model
 * @ClassName KmsAcceptanceFormDetailDwEntity
 * @Author Gavin
 * @Date 2021/5/11 下午2:48
 * @Description 验收单原始数据表
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("kms_acceptance_form_detail_dw")
@CrmTable(name = "kms_acceptance_form_detail_dw", tableNote = "验收单原始数据表")
public class KmsAcceptanceFormDetailDwEntity extends CrmExtTenEntity<KmsAcceptanceFormDetailDwEntity> {
    private static final long serialVersionUID = -7007081512719089902L;
    /**
     * 租户ID
     */
    @CrmColumn(name = "tenantry_id", length = 64, note = "租户ID")
    private String tenantryId;

    @CrmColumn(name = "raw_data_id", length = 64, note = "原始数据ID 对应表 kms_grab_response_data 的ID")
    private String rawDataId;

    @CrmColumn(name = "relate_order_number", length = 64, note = "关联订货单（kms_order_form_detail_dw：orderNumber）")
    private String relateOrderNumber;

    @CrmColumn(name = "relate_ka_order_number", length = 64, note = "关联原始订货单（kms_order_form_detail_dw：kaOrderNumber）")
    private String relateKaOrderNumber;

    @CrmColumn(name = "order_number", length = 64, note = "抓单生成的验收单编号")
    private String orderNumber;

    @CrmColumn(name = "ka_order_number", length = 64, note = "商超验收单编号")
    private String kaOrderNumber;

    @CrmColumn(name = "invoices_source", length = 64, note = "单据来源")
    private String invoicesSource;

    @CrmColumn(name = "order_status", length = 64, note = "验收单当前状态")
    private String orderStatus;

    @CrmColumn(name = "ka_code", length = 64, note = "商超编码")
    private String kaCode;

    @CrmColumn(name = "ka_name", length = 255, note = "商超名称")
    private String kaName;

    @CrmColumn(name = "ka_store_code", length = 64, note = "商超门店/大仓编号")
    private String kaStoreCode;

    @CrmColumn(name = "ka_store_name", length = 255, note = "商超门店/大仓名称")
    private String kaStoreName;

    @CrmColumn(name = "store_code", length = 64, note = "企业门店/大仓编号")
    private String storeCode;

    @CrmColumn(name = "store_name", length = 255, note = "企业门店/大仓名称")
    private String storeName;

    @CrmColumn(name = "acceptance_date", length = 255, note = "验收日期")
    private String acceptanceDate;

    @CrmColumn(name = "acceptance_type", length = 255, note = "验收类型")
    private String acceptanceType;

    @CrmColumn(name = "final_order_amount", length = 255, note = "订货单总金额（含税）")
    private String finalOrderAmount;

    @CrmColumn(name = "final_order_amount_not", length = 255, note = "订货单总金额（不含税）")
    private String finalOrderAmountNot;

    @CrmColumn(name = "final_acceptance_amount", length = 255, note = "验收单总金额（含税）")
    private String finalAcceptanceAmount;

    @CrmColumn(name = "final_acceptance_amount_not", length = 255, note = "验收单总金额（不含税）")
    private String finalAcceptanceAmountNot;

    @CrmColumn(name = "trans_status", length = 10, note = "字段转换标识：0未转换,-1转换失败，1已转换", defaultValue = "0")
    private String transStatus;

    @CrmColumn(name = "business_area_leader", length = 255, note = "业务区域负责人")
    private String businessAreaLeader;

    @CrmColumn(name = "business_area", length = 255, note = "业务区域")
    private String businessArea;

    @CrmColumn(name = "area_code", length = 64, note = "区域编码")
    private String areaCode;

    @CrmColumn(name = "area_name", length = 255, note = "区域名称")
    private String areaName;

    @CrmColumn(name = "sold_to_party_name", length = 255, note = "售达方名称")
    private String soldToPartyName;

    @CrmColumn(name = "sold_to_party_code", length = 64, note = "售达方编码")
    private String soldToPartyCode;

    @CrmColumn(name = "supplier_name", length = 255, note = "供应商名称")
    private String supplierName;

    @CrmColumn(name = "supplier_code", length = 64, note = "供应商编码")
    private String supplierCode;

    @CrmColumn(name = "user_name", length = 64, note = "登录账号")
    private String userName;
}