package com.biz.crm.rawdata.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * @Project crm
 * @PackageName com.biz.crm.orderform.model
 * @ClassName KmsRawOrderFormDetailDw
 * @Author Gavin
 * @Date 2021/4/27 上午10:27
 * @Description 原始订单头
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("kms_order_form_detail_dw")
@CrmTable(name = "kms_order_form_detail_dw", tableNote = "原始订单头表")
public class KmsOrderFormDetailDwEntity extends CrmExtTenEntity<KmsOrderFormDetailDwEntity> {
    private static final long serialVersionUID = 2094771431973931191L;

    @CrmColumn(name = "tenantry_id", length = 64, note = "租户ID")
    private String tenantryId;

    @CrmColumn(name = "raw_data_id", length = 64, note = "原始数据ID 对应表 kms_grab_response_data 的ID")
    private String rawDataId;

    @CrmColumn(name = "order_number", length = 64, note = "抓单生成的订单编号")
    private String orderNumber;

    @CrmColumn(name = "version_number", mysqlType = "int(11)", oracleType = "NUMBER(11,0)", note = "订单版本号")
    private Integer versionNumber;

    @CrmColumn(name = "ka_order_number", length = 64, note = "商超订单编号")
    private String kaOrderNumber;

    @CrmColumn(name = "order_status", length = 64, note = "订单当前状态")
    private String orderStatus;

    @CrmColumn(name = "invoices_source", length = 64, note = "单据来源")
    private String invoicesSource;

    @CrmColumn(name = "ka_code", length = 64, note = "商超编码")
    private String kaCode;

    @CrmColumn(name = "ka_name", length = 255, note = "商超名称")
    private String kaName;

    @CrmColumn(name = "order_date", length = 64, note = "订单日期")
    private String orderDate;

    @CrmColumn(name = "delivery_date", length = 64, note = "交货日期")
    private String deliveryDate;

    @CrmColumn(name = "run_mode", length = 64, note = "经营方式")
    private String runMode;

    @CrmColumn(name = "final_order_amount", length = 64, note = "订货单总金额（含税）")
    private String finalOrderAmount;

    @CrmColumn(name = "final_order_amount_not", length = 64, note = "订货单总金额（不含税）")
    private String finalOrderAmountNot;

    @CrmColumn(name = "ka_store_code", length = 64, note = "商超门店/大仓编号")
    private String kaStoreCode;

    @CrmColumn(name = "ka_store_name", length = 255, note = "商超门店/大仓名称")
    private String kaStoreName;

    @CrmColumn(name = "store_code", length = 64, note = "企业门店/大仓编号")
    private String storeCode;

    @CrmColumn(name = "store_name", length = 255, note = "企业门店/大仓名称")
    private String storeName;

    @CrmColumn(name = "delivery_address", length = 255, note = "送货地址")
    private String deliveryAddress;

    @CrmColumn(name = "delivery_contact", length = 64, note = "送货联系人")
    private String deliveryContact;

    @CrmColumn(name = "delivery_contact_phone", length = 64, note = "送货联系人电话")
    private String deliveryContactPhone;

    @CrmColumn(name = "business_area_leader", length = 64, note = "业务区域负责人")
    private String businessAreaLeader;

    @CrmColumn(name = "business_area", length = 64, note = "业务区域")
    private String businessArea;

    @CrmColumn(name = "area_code", length = 64, note = "区域编码")
    private String areaCode;

    @CrmColumn(name = "area_name", length = 255, note = "区域名称")
    private String areaName;

    @CrmColumn(name = "order_approval_number", length = 64, note = "订单审批单号")
    private String orderApprovalNumber;

    @CrmColumn(name = "sold_to_party_name", length = 255, note = "售达方名称")
    private String soldToPartyName;

    @CrmColumn(name = "sold_to_party_code", length = 64, note = "售达方编码")
    private String soldToPartyCode;

    @CrmColumn(name = "user_name", length = 64, note = "登录账号")
    private String userName;

    @CrmColumn(name = "trans_status", length = 64, note = "字段转换标识：0未转换,-1转换失败，1已转换", defaultValue = "0")
    private String transStatus;

    @CrmColumn(name = "max_unit_sum", length = 64, note = "SKU最大单位数量汇总")
    private String maxUnitSum;
}