package com.biz.crm.rawdata.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * @Project crm
 * @PackageName com.biz.crm.orderform.model
 * @ClassName KmsRawOrderGoodsDetailEntity
 * @Author Gavin
 * @Date 2021/4/27 上午11:15
 * @Description 原单订单行数据信息
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("kms_order_goods_detail_dw")
@CrmTable(name = "kms_order_goods_detail_dw", tableNote = "原单订单行数据信息")
public class KmsOrderGoodsDetailDwEntity extends CrmExtTenEntity<KmsOrderGoodsDetailDwEntity> {
    private static final long serialVersionUID = -7794792815849675707L;

    @CrmColumn(name = "tenantry_id", length = 64, note = "租户ID")
    private String tenantryId;

    @CrmColumn(name = "order_number", length = 64, note = "抓单生成的订单编号")
    private String orderNumber;

    @CrmColumn(name = "raw_data_id", length = 64, note = "原始数据ID 对应表 kms_grab_response_data 的ID")
    private String rawDataId;

    @CrmColumn(name = "version_number", mysqlType = "int(11)", oracleType = "NUMBER(11,0)", note = "订单版本号")
    private Integer versionNumber;

    @CrmColumn(name = "ka_order_number", length = 64, note = "商超订单编号")
    private String kaOrderNumber;

    @CrmColumn(name = "ka_name", length = 255, note = "商超名称")
    private String kaName;

    @CrmColumn(name = "goods_code", length = 64, note = "企业产品编号")
    private String goodsCode;

    @CrmColumn(name = "goods_name", length = 255, note = "企业产品名称")
    private String goodsName;

    @CrmColumn(name = "ka_goods_code", length = 64, note = "商超产品编号")
    private String kaGoodsCode;

    @CrmColumn(name = "ka_goods_name", length = 255, note = "商超产品名称")
    private String kaGoodsName;

    @CrmColumn(name = "goods_bar_code", length = 64, note = "产品国际条码")
    private String goodsBarCode;

    @CrmColumn(name = "specification", length = 64, note = "产品规格")
    private String specification;

    @CrmColumn(name = "unit_price", length = 64, note = "订货单价（含税）")
    private String unitPrice;

    @CrmColumn(name = "order_amount", length = 64, note = "订货金额小计（含税）")
    private String orderAmount;

    @CrmColumn(name = "unit_price_not", length = 64, note = "订货单价（不含税）")
    private String unitPriceNot;

    @CrmColumn(name = "order_amount_not", length = 64, note = "订货金额小计（不含税）")
    private String orderAmountNot;

    @CrmColumn(name = "sold_to_party_name", length = 255, note = "售达方名称")
    private String soldToPartyName;

    @CrmColumn(name = "sold_to_party_code", length = 64, note = "售达方编码")
    private String soldToPartyCode;

    @CrmColumn(name = "cur_unit_level", length = 64, note = "当前单位层级")
    private String curUnitLevel;

    @CrmColumn(name = "cur_unit", length = 64, note = "商超当前单位")
    private String curUnit;

    @CrmColumn(name = "cur_unit_order_quantity", length = 64, note = "商超当前单位订货数量")
    private String curUnitOrderQuantity;

    @CrmColumn(name = "min_unit_level", length = 64, note = "最小单位层级")
    private String minUnitLevel;

    @CrmColumn(name = "min_unit", length = 64, note = "最小单位")
    private String minUnit;

    @CrmColumn(name = "min_unit_order_quantity", length = 64, note = "最小单位订货数量")
    private String minUnitOrderQuantity;

    @CrmColumn(name = "max_unit_level", length = 64, note = "最大单位层级")
    private String maxUnitLevel;

    @CrmColumn(name = "max_unit", length = 64, note = "最大单位")
    private String maxUnit;

    @CrmColumn(name = "max_unit_order_quantity", length = 64, note = "最大单位订货数量")
    private String maxUnitOrderQuantity;

    @CrmColumn(name = "factory_code", length = 64, note = "工厂编码")
    private String factoryCode;

    @CrmColumn(name = "factory_name", length = 255, note = "工厂名称")
    private String factoryName;

    @CrmColumn(name = "pro_rate", length = 64, note = "产品税率")
    private String proRate;

    @CrmColumn(name = "pro_rebate", length = 64, note = "折扣")
    private String proRebate;

    @CrmColumn(name = "data_from", length = 255, note = "详情来源")
    private String dataFrom;

    @CrmColumn(name = "order_price", length = 255, note = "维护单价")
    private String orderPrice;

    @CrmColumn(name = "price_diff", length = 255, note = "单价差异")
    private String priceDiff;

    @CrmColumn(name = "trans_status", length = 64, note = "字段转换标识：0未转换,-1转换失败，1已转换", defaultValue = "0")
    private String transStatus;

    @CrmColumn(name = "item_index", mysqlType = "int(11)", oracleType = "NUMBER(11,0)", note = "行信息排序")
    private Integer itemIndex;
}