package com.biz.crm.rawdata.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * @Project crm
 * @PackageName com.biz.crm.rawdata.model
 * @ClassName KmsReturnFormDetailDwEntity
 * @Author Gavin
 * @Date 2021/5/11 下午4:22
 * @Description 退货单原始数据表
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("kms_return_form_detail_dw")
@CrmTable(name = "kms_return_form_detail_dw", tableNote = "退货单原始数据表")
public class KmsReturnFormDetailDwEntity extends CrmExtTenEntity<KmsOrderFormDetailDwEntity> {
    private static final long serialVersionUID = 8066562165703514631L;

    @CrmColumn(name = "tenantry_id", length = 64, note = "租户ID")
    private String tenantryId;

    @CrmColumn(name = "raw_data_id", length = 64, note = "原始数据ID 对应表 kms_grab_response_data 的ID")
    private String rawDataId;

    @CrmColumn(name = "order_number", length = 64, note = "抓单生成的退货单编号")
    private String orderNumber;

    @CrmColumn(name = "version_number", mysqlType = "int(11)", oracleType = "NUMBER(11,0)", note = "订单版本号")
    private Integer versionNumber;

    @CrmColumn(name = "order_status", length = 64, note = "退货单当前状态")
    private String orderStatus;

    @CrmColumn(name = "ka_order_number", length = 64, note = "商超退货单编号")
    private String kaOrderNumber;

    @CrmColumn(name = "invoices_source", length = 64, note = "单据来源")
    private String invoicesSource;

    @CrmColumn(name = "relate_custom_order", length = 64, note = "关联客户订单")
    private String relateCustomOrder;

    @CrmColumn(name = "ka_code", length = 64, note = "商超编码")
    private String kaCode;

    @CrmColumn(name = "ka_name", length = 255, note = "商超名称")
    private String kaName;

    @CrmColumn(name = "ka_store_code", length = 64, note = "商超门店/大仓编号")
    private String kaStoreCode;

    @CrmColumn(name = "ka_store_name", length = 255, note = "商超门店/大仓名称")
    private String kaStoreName;

    @CrmColumn(name = "store_code", length = 64, note = "企业门店/大仓编号")
    private String storeCode;

    @CrmColumn(name = "store_name", length = 255, note = "企业门店/大仓名称")
    private String storeName;

    @CrmColumn(name = "order_date", length = 64, note = "单据日期")
    private String orderDate;

    @CrmColumn(name = "return_reason", length = 255, note = "退货原因")
    private String returnReason;

    @CrmColumn(name = "final_return_amount", length = 255, note = "退货订单总金额（含税）")
    private String finalReturnAmount;

    @CrmColumn(name = "final_return_amount_not", length = 255, note = "退货订单总金额（不含税）")
    private String finalReturnAmountNot;

    @CrmColumn(name = "max_unit_sum", length = 255, note = "SKU最大单位数量汇总")
    private String maxUnitSum;

    @CrmColumn(name = "trans_status", length = 64, note = "字段转换标识：0未转换,-1转换失败，1已转换", defaultValue = "0")
    private String transStatus;

    @CrmColumn(name = "business_area_leader", length = 64, note = "业务区域负责人")
    private String businessAreaLeader;

    @CrmColumn(name = "business_area", length = 64, note = "业务区域")
    private String businessArea;

    @CrmColumn(name = "area_code", length = 64, note = "区域编码")
    private String areaCode;

    @CrmColumn(name = "area_name", length = 255, note = "区域名称")
    private String areaName;

    @CrmColumn(name = "order_approval_number", length = 64, note = "订单审批单号")
    private String orderApprovalNumber;

    @CrmColumn(name = "sold_to_party_name", length = 255, note = "售达方名称")
    private String soldToPartyName;

    @CrmColumn(name = "sold_to_party_code", length = 64, note = "售达方编码")
    private String soldToPartyCode;

    @CrmColumn(name = "user_name", length = 64, note = "登录账号")
    private String userName;

    @CrmColumn(name = "return_amount", length = 64, note = "退货金额（含税）")
    private String returnAmount;
}