package com.biz.crm.rawdata.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * @Project crm
 * @PackageName com.biz.crm.rawdata.model
 * @ClassName KmsReturnGoodsDetailDwEntity
 * @Author Gavin
 * @Date 2021/5/11 下午4:37
 * @Description 原始退货单详情表
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("kms_return_goods_detail_dw")
@CrmTable(name = "kms_return_goods_detail_dw", tableNote = "原单订单行数据信息")
public class KmsReturnGoodsDetailDwEntity extends CrmExtTenEntity<KmsReturnGoodsDetailDwEntity> {
    private static final long serialVersionUID = 6820064205293986368L;

    @CrmColumn(name = "tenantry_id", length = 64, note = "租户ID")
    private String tenantryId;

    @CrmColumn(name = "raw_data_id", length = 64, note = "原始数据ID 对应表 kms_grab_response_data 的ID")
    private String rawDataId;

    @CrmColumn(name = "order_number", length = 64, note = "抓单生成的退货单编号")
    private String orderNumber;

    @CrmColumn(name = "version_number", mysqlType = "int(11)", oracleType = "NUMBER(11,0)", note = "订单版本号")
    private Integer versionNumber;

    @CrmColumn(name = "ka_order_number", length = 64, note = "商超退货单编号")
    private String kaOrderNumber;

    @CrmColumn(name = "goods_code", length = 64, note = "企业产品编号")
    private String goodsCode;

    @CrmColumn(name = "goods_name", length = 255, note = "企业产品名称")
    private String goodsName;

    @CrmColumn(name = "ka_goods_code", length = 64, note = "商超产品编号")
    private String kaGoodsCode;

    @CrmColumn(name = "ka_goods_name", length = 255, note = "商超产品名称")
    private String kaGoodsName;

    @CrmColumn(name = "goods_bar_code", length = 64, note = "产品国际条码")
    private String goodsBarCode;

    @CrmColumn(name = "specification", length = 64, note = "产品规格")
    private String specification;

    @CrmColumn(name = "unit_price", length = 64, note = "退货单价（含税）")
    private String unitPrice;

    @CrmColumn(name = "return_amount", length = 64, note = "退货金额小计（含税）")
    private String returnAmount;

    @CrmColumn(name = "unit_price_not", length = 64, note = "退货单价（不含税）")
    private String unitPriceNot;

    @CrmColumn(name = "return_amount_not", length = 64, note = "退货金额小计（不含税）")
    private String returnAmountNot;

    @CrmColumn(name = "trans_status", length = 64, note = "字段转换标识：0未转换,-1转换失败，1已转换", defaultValue = "0")
    private String transStatus;

    @CrmColumn(name = "sold_to_party_name", length = 255, note = "售达方名称")
    private String soldToPartyName;

    @CrmColumn(name = "sold_to_party_code", length = 64, note = "售达方编码")
    private String soldToPartyCode;

    @CrmColumn(name = "cur_unit_level", length = 64, note = "当前单位层级")
    private String cur_unit_level;

    @CrmColumn(name = "cur_unit", length = 64, note = "当前单位")
    private String curUnit;

    @CrmColumn(name = "cur_unit_order_quantity", length = 64, note = "当前单位订货数量")
    private String curUnitOrderQuantity;

    @CrmColumn(name = "min_unit_level", length = 64, note = "最小单位层级")
    private String minUnitLevel;

    @CrmColumn(name = "min_unit", length = 64, note = "最小单位")
    private String minUnit;

    @CrmColumn(name = "min_unit_order_quantity", length = 64, note = "最小单位订货数量")
    private String minUnitOrderQuantity;

    @CrmColumn(name = "max_unit_level", length = 64, note = "最大单位层级")
    private String maxUnitLevel;

    @CrmColumn(name = "max_unit", length = 64, note = "最大单位")
    private String maxUnit;

    @CrmColumn(name = "max_unit_order_quantity", length = 64, note = "最大单位订货数量")
    private String maxUnitOrderQuantity;

    @CrmColumn(name = "ka_name", length = 255, note = "商超名称")
    private String kaName;

    @CrmColumn(name = "user_name", length = 64, note = "登录账号")
    private String userName;

    @CrmColumn(name = "item_index", mysqlType = "int(11)", oracleType = "NUMBER(11,0)", note = "行信息排序")
    private Integer itemIndex;
}