package com.biz.crm.returnform.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * @Project crm
 * @PackageName com.biz.crm.returnform.model
 * @ClassName KmsReturnStatusRecordEntity
 * @Author Gavin
 * @Date 2021/5/11 下午5:13
 * @Description 退货单状态记录表
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("kms_return_status_record")
@CrmTable(name = "kms_return_status_record", tableNote = "退货单状态记录表",indexes = {
        @Index(name = "krsr_order_number_index", columnList = "order_number"),
        @Index(name = "krsr_version_number_index",columnList = "version_number"),
        @Index(name = "krsr_ka_order_number_index", columnList = "ka_order_number")
})
public class KmsReturnStatusRecordEntity extends CrmExtTenEntity<KmsReturnStatusRecordEntity> {
    private static final long serialVersionUID = -2270777642712597343L;
    @CrmColumn(name = "order_number", length = 64, note = "抓单生成的退货单编号")
    private String orderNumber;

    @CrmColumn(name = "version_number", mysqlType = "int(11)", oracleType = "NUMBER(11,0)", note = "订单版本号")
    private Integer versionNumber;

    @CrmColumn(name = "ka_order_number", length = 64, note = "商超退货单编号")
    private String kaOrderNumber;

    @CrmColumn(name = "order_status", length = 64, note = "订单当前状态 枚举KmsEnum.OrderStatus")
    private String orderStatus;

    @CrmColumn(name = "order_status_msg", length = 512, note = "单据当前状态信息")
    private String orderStatusMsg;
}