package com.biz.crm.salesdata.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 销售数据表
 *
 * @describe: 销售数据
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2021/8/20 11:46
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("kms_sales_data")
@CrmTable(name = "kms_sales_data", tableNote = "销售数据表", indexes = {
        @Index(name = "kms_sales_data_index1", columnList = "tenantry_id"),
        @Index(name = "kms_sales_data_index2", columnList = "order_number"),
        @Index(name = "kms_sales_data_index3", columnList = "raw_data_id"),
        @Index(name = "kms_sales_data_index5", columnList = "version_number"),
        @Index(name = "kms_sales_data_index6", columnList = "ka_order_number"),
        @Index(name = "kms_sales_data_index7", columnList = "ka_store_code"),
        @Index(name = "kms_sales_data_index8", columnList = "sales_date"),
})
public class KmsSalesDataEntity extends CrmExtTenEntity<KmsSalesDataEntity> {

    private static final long serialVersionUID = -5147391560578074764L;

    @CrmColumn(name = "tenantry_id", length = 64, note = "租户ID")
    private String tenantryId;

    @CrmColumn(name = "raw_data_id", length = 64, note = "原始数据ID 对应表 kms_grab_response_data 的ID")
    private String rawDataId;

    @CrmColumn(name = "order_number", length = 64, note = "企业销售数据编号")
    private String orderNumber;

    @CrmColumn(name = "version_number", mysqlType = "int(11)", oracleType = "NUMBER(11,0)", note = "版本号")
    private Integer versionNumber;

    @CrmColumn(name = "ka_order_number", length = 64, note = "商超单据编号")
    private String kaOrderNumber;

    @CrmColumn(name = "invoices_source", length = 64, note = "单据来源")
    private String invoicesSource;

    @CrmColumn(name = "ka_code", length = 64, note = "商超编码")
    private String kaCode;

    @CrmColumn(name = "ka_name", length = 255, note = "商超名称")
    private String kaName;

    @CrmColumn(name = "sales_date", length = 64, note = "销售日期")
    private String salesDate;

    @CrmColumn(name = "ka_store_code", length = 64, note = "商超门店/大仓编号")
    private String kaStoreCode;

    @CrmColumn(name = "ka_store_name", length = 255, note = "商超门店/大仓名称")
    private String kaStoreName;

    @CrmColumn(name = "store_code", length = 64, note = "企业门店/大仓编号")
    private String storeCode;

    @CrmColumn(name = "store_name", length = 255, note = "企业门店/大仓名称")
    private String storeName;

    @CrmColumn(name = "goods_code", length = 64, note = "企业产品编号")
    private String goodsCode;

    @CrmColumn(name = "goods_name", length = 255, note = "企业产品名称")
    private String goodsName;

    @CrmColumn(name = "ka_goods_code", length = 64, note = "商超产品编号")
    private String kaGoodsCode;

    @CrmColumn(name = "ka_goods_name", length = 255, note = "商超产品名称")
    private String kaGoodsName;

    @CrmColumn(name = "goods_bar_code", length = 64, note = "产品国际条码")
    private String goodsBarCode;

    @CrmColumn(name = "specification", length = 64, note = "产品规格")
    private String specification;

    @CrmColumn(name = "sales_cost", length = 64, note = "销售成本")
    private String salesCost;

    @CrmColumn(name = "sales_amount", length = 64, note = "销售金额")
    private String salesAmount;

    @CrmColumn(name = "run_mode", length = 64, note = "经营方式")
    private String runMode;

    @CrmColumn(name = "area_code", length = 64, note = "门店所属大区编号")
    private String areaCode;

    @CrmColumn(name = "area_name", length = 255, note = "门店所属大区名称")
    private String areaName;

    @CrmColumn(name = "competitive_brands", length = 64, note = "竞品品牌")
    private String competitiveBrands;

    @CrmColumn(name = "cur_unit_level", length = 64, note = "商超当前单位层级")
    private String curUnitLevel;

    @CrmColumn(name = "cur_unit", length = 64, note = "商超当前单位")
    private String curUnit;

    @CrmColumn(name = "cur_unit_sales_quantity", length = 64, note = "商超当前单位销售数量")
    private String curUnitSalesQuantity;

    @CrmColumn(name = "min_unit_level", length = 64, note = "商超最小单位层级")
    private String minUnitLevel;

    @CrmColumn(name = "min_unit", length = 64, note = "商超最小单位")
    private String minUnit;

    @CrmColumn(name = "min_unit_sales_quantity", length = 64, note = "商超最小单位销售数量")
    private String minUnitSalesQuantity;

    @CrmColumn(name = "max_unit_level", length = 64, note = "商超最大单位层级")
    private String maxUnitLevel;

    @CrmColumn(name = "max_unit", length = 64, note = "商超最大单位")
    private String maxUnit;

    @CrmColumn(name = "max_unit_sales_quantity", length = 64, note = "商超最大单位销售数量")
    private String maxUnitSalesQuantity;

    @CrmColumn(name = "business_area", length = 64, note = "业务区域")
    private String businessArea;

    @CrmColumn(name = "user_name", length = 64, note = "登录账号")
    private String userName;

    /**
     * 直营体系Id
     */
    @CrmColumn(name = "bs_direct_system_id", length = 64, note = "直营体系Id")
    private String bsDirectSystemId;

    @CrmColumn(name = "order_status", length = 64, note = "单据当前状态")
    private String orderStatus;

    @CrmColumn(name = "order_status_msg", length = 512, note = "单据当前状态信息")
    private String orderStatusMsg;

    /**
     * 关联ID(企业商品与商超商品表ID)
     */
    @CrmColumn(name = "goods_related_id", length = 64, note = "关联ID(企业商品与商超商品表ID)")
    private String goodsRelatedId;

    @CrmColumn(name = "cur_company_unit", length = 64, note = "企业当前销售单位")
    private String curCompanyUnit;

    @CrmColumn(name = "cur_company_unit_order_quantity", length = 64, note = "企业当前单位销售数量")
    private String curCompanyUnitOrderQuantity;

}
