package com.biz.crm.sap.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * @Project crm
 * @PackageName com.biz.crm.sap.model
 * @ClassName KmsSapOrderFormEntity
 * @Author Gavin
 * @Date 2021/5/27 下午2:22
 * @Description SAP单据
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("kms_sap_order_form")
@CrmTable(name = "kms_sap_order_form", tableNote = "SAP数据",indexes = {
        @Index(name = "ksof_sap_no_index", columnList = "sap_no"),
        @Index(name = "ksof_audit_template_id_index", columnList = "audit_template_id")
})
public class KmsSapOrderFormEntity extends CrmExtTenEntity<KmsSapOrderFormEntity> {
    private static final long serialVersionUID = -970314702471669025L;

    /**
     * sap单据编码
     */
    @CrmColumn(name = "sap_no", length = 512, note = "sap单据编码")
    private String sapNo;

    /**
     * sap过账日期
     */
    @CrmColumn(name = "sap_posting_date", length = 512, note = "sap过账日期")
    private String sapPostingDate;

    /**
     * 送达方编号
     */
    @CrmColumn(name = "store_code", length = 512, note = "送达方编号")
    private String storeCode;

    /**
     * 送达方名称
     */
    @CrmColumn(name = "store_name", length = 512, note = "送达方名称")
    private String storeName;

    /**
     * SAP物料号
     */
    @CrmColumn(name = "sap_materiel_code", length = 512, note = "SAP物料号")
    private String sapMaterielCode;

    /**
     * SAP物料名称
     */
    @CrmColumn(name = "sap_materiel_name", length = 512, note = "SAP物料名称")
    private String sapMaterielName;

    /**
     * 商品类型
     */
    @CrmColumn(name = "product_type", length = 512, note = "商品类型")
    private String productType;

    /**
     * SAP数量
     */
    @CrmColumn(name = "sap_quantity", length = 512, note = "SAP数量")
    private String sapQuantity;

    /**
     * SAP总金额（不含税）
     */
    @CrmColumn(name = "sap_amount_not", length = 512, note = "SAP总金额（不含税）")
    private String sapAmountNot;

    /**
     * SAP总金额（含税）
     */
    @CrmColumn(name = "sap_amount", length = 512, note = "SAP总金额（含税）")
    private String sapAmount;

    /**
     * 配送商
     */
    @CrmColumn(name = "distributor", length = 512, note = "配送商")
    private String distributor;

    /**
     * 匹配模版ID集合(用于判断当前规则是否汇总当前数据)
     */
    @CrmColumn(name = "audit_template_id", length = 512, note = "匹配模版ID集合(用于判断当前规则是否汇总当前数据)")
    private String auditTemplateId;
}