package com.biz.crm.supermarket.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * @Project crm
 * @PackageName com.biz.crm.supermarket.model
 * @ClassName KmsSupplierEntity
 * @Author Gavin
 * @Date 2021/7/6 下午1:33
 * @Description 供应商
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("kms_supplier")
@CrmTable(name = "kms_supplier", tableNote = "售达方与供应商关系表", indexes = {
        @Index(name = "ksu_bs_direct_system_id_index", columnList = "bs_direct_system_id"),
        @Index(name = "ksu_sell_party_id_index", columnList = "sell_party_id"),
})
public class KmsSupplierEntity  extends CrmExtTenEntity<KmsSupplierEntity> {

    private static final long serialVersionUID = -488333691193839141L;

    /**
     * 直营体系Id
     */
    @CrmColumn(name = "bs_direct_system_id", length = 64, note = "直营体系Id")
    private String bsDirectSystemId;

    /**
     * 直营体系编码
     */
    @CrmColumn(name = "bs_direct_system_code", length = 64, note = "直营体系编码")
    private String bsDirectSystemCode;


    /**
     * 直营体系名称
     */
    @CrmColumn(name = "bs_direct_system_name", length = 256, note = "直营体系名称")
    private String bsDirectSystemName;

    /**
     * 售达方Id
     */
    @CrmColumn(name = "sell_party_id", length = 64, note = "售达方Id")
    private String sellPartyId;


    /**
     * 售达方编码
     */
    @CrmColumn(name = "sell_party_code", length = 64, note = "售达方编码")
    private String sellPartyCode;


    /**
     * 售达方名称
     */
    @CrmColumn(name = "sell_party_name", length = 512, note = "售达方名称")
    private String sellPartyName;


    /**
     * 供应商编码
     */
    @CrmColumn(name = "supplier_code", length = 64, note = "供应商编码")
    private String supplierCode;
}