package com.biz.crm.supermarket.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 抓单账号管理实体类
 *
 * @author Gavin
 * @date 2021-04-13 23:19:46
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("kms_tenantry_direct_account")
@CrmTable(name = "kms_tenantry_direct_account", tableNote = "抓单账号管理",indexes = {
        @Index(name = "ktda_bs_direct_system_code_index", columnList = "bs_direct_system_code")
})
public class KmsTenantryDirectAccountEntity extends CrmExtTenEntity<KmsTenantryDirectAccountEntity> {


    private static final long serialVersionUID = 9082680907633370858L;

    /**
     * 直营体系Id
     */
    @CrmColumn(name = "bs_direct_system_id", length = 64, note = "直营体系Id")
    private String bsDirectSystemId;

    /**
     * 直营体系编码
     */
    @CrmColumn(name = "bs_direct_system_code", length = 64, note = "直营体系编码")
    private String bsDirectSystemCode;


    /**
     * 直营体系名称
     */
    @CrmColumn(name = "bs_direct_system_name", length = 256, note = "直营体系名称")
    private String bsDirectSystemName;


    /**
     * 登录账号
     */
    @CrmColumn(name = "login_acc", length = 32, note = "登录账号")
    private String loginAcc;


    /**
     * 登录密码
     */
    @CrmColumn(name = "login_pass", length = 32, note = "登录密码")
    private String loginPass;

}
