package com.biz.crm.supermarket.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * @author maoshen
 * @date 2021/6/26.
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("kms_total_warehouse_store")
@CrmTable(name = "kms_total_warehouse_store", tableNote = "总仓门店")
public class KmsTotalWarehouseStoreEntity extends CrmExtTenEntity<KmsTotalWarehouseStoreEntity> {
    private static final long serialVersionUID = -1038755808810035724L;

    /**
     * 直营体系Id
     */
    @CrmColumn(name = "bs_direct_system_id", length = 64, note = "直营体系Id")
    private String bsDirectSystemId;

    /**
     * 直营体系编码
     */
    @CrmColumn(name = "bs_direct_system_code", length = 64, note = "直营体系编码")
    private String bsDirectSystemCode;


    /**
     * 直营体系名称
     */
    @CrmColumn(name = "bs_direct_system_name", length = 256, note = "直营体系名称")
    private String bsDirectSystemName;

    /**
     * 产品类型
     */
    @CrmColumn(name = "product_type", length = 64, note = "产品类型")
    private String productType;

    /**
     * 售达方id
     */
    @CrmColumn(name = "sell_party_id", length = 64, note = "售达方id")
    private String sellPartyId;

    /**
     * 售达方编码
     */
    @CrmColumn(name = "sell_party_code", length = 64, note = "售达方编码")
    private String sellPartyCode;


    /**
     * 售达方名称
     */
    @CrmColumn(name = "sell_party_name", length = 512, note = "售达方名称")
    private String sellPartyName;


    @ApiModelProperty("直营门店ID")
    @CrmColumn(name = "direct_store_id", length = 512, note = "直营门店ID")
    private String directStoreId;

    @CrmColumn(name = "terminal_code", length = 512, note = "送达方编码")
    private String terminalCode;

    @CrmColumn(name = "terminal_name", length = 512, note = "送达方名称")
    private String terminalName;

    @CrmColumn(name = "direct_product_id", length = 64, note = "上架产品ID")
    private String directProductId;

    /**
     * 上架产品编码
     */
    @CrmColumn(name = "ka_product_code", length = 64, note = "商超产品编码")
    private String kaProductCode;

    /**
     * 企业产品编码
     */
    @CrmColumn(name = "product_code", length = 64, note = "企业产品编码")
    private String productCode;

    /**
     * 企业产品名称
     */
    @CrmColumn(name = "product_name", length = 512, note = "企业产品名称")
    private String productName;
}
