package com.biz.crm.acceptanceform.helper;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.biz.crm.acceptanceform.mapper.KmsAcceptanceFormMapper;
import com.biz.crm.acceptanceform.mapper.KmsAcceptanceGoodsMapper;
import com.biz.crm.acceptanceform.model.KmsAcceptanceFormEntity;
import com.biz.crm.acceptanceform.model.KmsAcceptanceGoodsEntity;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.kms.KmsAdminEnum;
import com.biz.crm.eunm.kms.KmsEnum;
import com.biz.crm.grabrule.mapper.KmsDataAuthMapper;
import com.biz.crm.nebular.kms.rawdata.resp.KmsAcceptanceFormDetailDwRespVo;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.biz.crm.rawdata.model.KmsAcceptanceFormDetailDwEntity;
import com.biz.crm.rawdata.model.KmsAcceptanceGoodsDetailDwEntity;
import com.biz.crm.rawdata.service.IKmsAcceptanceFormDetailDwService;
import com.biz.crm.rawdata.service.IKmsAcceptanceGoodsDetailDwService;
import com.biz.crm.trans.service.IKmsTransDataService;
import com.biz.crm.trans.vo.TransDataGoodsVo;
import com.biz.crm.trans.vo.TransDataStoreVo;
import com.biz.crm.trans.vo.TransDataVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.KmsUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Project crm
 * @PackageName com.biz.crm.acceptanceform.helper
 * @ClassName KmsAcceptanceFormHelper
 * @Author Gavin
 * @Date 2021/5/21 下午2:29
 * @Description 验收单助手
 */
@Slf4j
@Component
public class KmsAcceptanceFormHelper {

    @Resource
    private KmsAcceptanceFormMapper kmsAcceptanceFormMapper;

    @Resource
    private KmsAcceptanceGoodsMapper kmsAcceptanceGoodsMapper;

    @Resource
    private IKmsAcceptanceFormDetailDwService kmsAcceptanceFormDetailDwService;

    @Resource
    private IKmsAcceptanceGoodsDetailDwService kmsAcceptanceGoodsDetailDwService;

    @Resource
    private IKmsTransDataService kmsTransDataService;

    @Resource
    private KmsDataAuthMapper kmsDataAuthMapper;

    /**
     * 匹配处理验收单版本信息
     *
     * @param orderNumber
     * @return
     */
    public KmsAcceptanceFormEntity transFormVersion(KmsAcceptanceFormDetailDwRespVo dwRespVo) {
        String orderNumber = dwRespVo.getOrderNumber();
        //根据订单号查询原始单据
        KmsAcceptanceFormDetailDwEntity dwEntity = kmsAcceptanceFormDetailDwService.lambdaQuery()
                .eq(KmsAcceptanceFormDetailDwEntity::getOrderNumber, orderNumber).one();
        //查询是否存在已转换数据
        LambdaQueryWrapper<KmsAcceptanceFormEntity> build = new LambdaQueryWrapper<KmsAcceptanceFormEntity>()
                .eq(KmsAcceptanceFormEntity::getOrderNumber, orderNumber);
        KmsAcceptanceFormEntity acceptanceFormEntity = kmsAcceptanceFormMapper.selectOne(build);
        if (ObjectUtils.isEmpty(acceptanceFormEntity)) {
            acceptanceFormEntity = CrmBeanUtil.copy(dwEntity, KmsAcceptanceFormEntity.class);
            //赋予权限信息
            acceptanceFormEntity.setCreateCode(dwRespVo.getCreateCode());
            acceptanceFormEntity.setCreateName(dwRespVo.getCreateName());
            acceptanceFormEntity.setCreateOrgCode(dwRespVo.getCreateOrgCode());
            acceptanceFormEntity.setCreateOrgName(dwRespVo.getCreateOrgName());
            acceptanceFormEntity.setCreatePosCode(dwRespVo.getCreatePosCode());
            acceptanceFormEntity.setCreatePosName(dwRespVo.getCreatePosName());
            acceptanceFormEntity.setBsDirectSystemId(dwRespVo.getBsDirectSystemId());
        }/*else if(!KmsEnum.OrderStatus.S600.getValue().equals(acceptanceFormEntity.getOrderStatus())){
            BeanUtils.copyProperties(dwEntity, acceptanceFormEntity, KmsUtils.ignoreProperties());
            acceptanceFormEntity.setRemarks(dwEntity.getRemarks());
        }*/
        //更改转换标示为已转换
        dwEntity.setTransStatus(YesNoEnum.yesNoEnum.ONE.getValue());
        kmsAcceptanceFormDetailDwService.updateById(dwEntity);
        return acceptanceFormEntity;
    }

    /**
     * 匹配处理验收单商品详情新版本数据
     *
     * @param acceptanceFormEntities
     * @param orderNumbers
     * @return
     */
    public List<KmsAcceptanceGoodsEntity> transGoodsVersion(KmsAcceptanceFormEntity acceptanceFormEntity) {
        String orderNumber = acceptanceFormEntity.getOrderNumber();
        LambdaUpdateWrapper<KmsAcceptanceGoodsEntity> wrapper = new LambdaUpdateWrapper<KmsAcceptanceGoodsEntity>()
                .eq(KmsAcceptanceGoodsEntity::getOrderNumber, orderNumber);
        List<KmsAcceptanceGoodsEntity> deleteAcceptanceGoodsEntities = kmsAcceptanceGoodsMapper.selectList(wrapper);
        Map<String, KmsAcceptanceGoodsEntity> goodsMap = deleteAcceptanceGoodsEntities.stream()
                .collect(Collectors.toMap(o -> o.getOrderNumber() + "-" + o.getKaGoodsCode(), Function.identity()));
        //订单号查询原始订货单商品详情信息
        List<KmsAcceptanceGoodsDetailDwEntity> detailDwEntities = kmsAcceptanceGoodsDetailDwService.lambdaQuery()
                .eq(KmsAcceptanceGoodsDetailDwEntity::getOrderNumber, orderNumber)
                .list();
        Map<String, KmsAcceptanceGoodsDetailDwEntity> dwEntityMap = detailDwEntities.stream()
                .collect(Collectors.toMap(o -> o.getOrderNumber() + "-" + o.getKaGoodsCode(), Function.identity(), (v1, v2) -> v1));
        //验收单商品详情
        Map<String, KmsAcceptanceGoodsEntity> onlyMap = Maps.newHashMap();
        detailDwEntities.forEach(o -> {
            String key = o.getOrderNumber() + "-" + o.getKaGoodsCode();
            KmsAcceptanceGoodsEntity goodsEntity = CrmBeanUtil.copy(o, KmsAcceptanceGoodsEntity.class);
            goodsEntity.setAcceptanceAmount(StringUtils.isEmpty(goodsEntity.getAcceptanceAmount()) ? "0" : goodsEntity.getAcceptanceAmount());
            goodsEntity.setAcceptanceAmountNot(StringUtils.isEmpty(goodsEntity.getAcceptanceAmountNot()) ? "0" : goodsEntity.getAcceptanceAmountNot());
            goodsEntity.setCurUnitAcceptanceQuantity(StringUtils.isEmpty(goodsEntity.getCurUnitAcceptanceQuantity()) ? "0" : goodsEntity.getCurUnitAcceptanceQuantity());
            goodsEntity.setOrderAmount(StringUtils.isEmpty(goodsEntity.getOrderAmount()) ? "0" : goodsEntity.getOrderAmount());
            goodsEntity.setOrderAmountNot(StringUtils.isEmpty(goodsEntity.getOrderAmountNot()) ? "0" : goodsEntity.getOrderAmountNot());
            goodsEntity.setOrderQuantity(StringUtils.isEmpty(goodsEntity.getOrderQuantity()) ? "0" : goodsEntity.getOrderQuantity());
            goodsEntity.setRemarks(o.getRemarks());
            //判断是否重复
            if (!ObjectUtils.isEmpty(onlyMap.get(key))) {
                KmsAcceptanceGoodsEntity en = onlyMap.get(key);
                en.setAcceptanceAmount(new BigDecimal(en.getAcceptanceAmount())
                        .add(new BigDecimal(goodsEntity.getAcceptanceAmount())).toString());
                en.setAcceptanceAmountNot(new BigDecimal(en.getAcceptanceAmountNot())
                        .add(new BigDecimal(goodsEntity.getAcceptanceAmountNot())).toString());
                en.setCurUnitAcceptanceQuantity(new BigDecimal(en.getCurUnitAcceptanceQuantity())
                        .add(new BigDecimal(goodsEntity.getCurUnitAcceptanceQuantity())).toString());
                en.setOrderAmount(new BigDecimal(en.getOrderAmount())
                        .add(new BigDecimal(goodsEntity.getOrderAmount())).toString());
                en.setOrderAmountNot(new BigDecimal(en.getOrderAmountNot())
                        .add(new BigDecimal(goodsEntity.getOrderAmountNot())).toString());
                en.setOrderQuantity(new BigDecimal(en.getOrderQuantity())
                        .add(new BigDecimal(goodsEntity.getOrderQuantity())).toString());
                onlyMap.put(key, en);
            } else {
                KmsAcceptanceGoodsEntity entity = ObjectUtils.isEmpty(goodsMap.get(key))
                        ? new KmsAcceptanceGoodsEntity() : goodsMap.get(key);
                BeanUtils.copyProperties(goodsEntity, entity, KmsUtils.ignoreProperties());
                onlyMap.put(key, entity);
            }
        });
        //删除数据
        List<String> goodsIds = Lists.newArrayList();
        goodsMap.forEach((k, v) -> {
            if (ObjectUtils.isEmpty(dwEntityMap.get(k))) {
                goodsIds.add(v.getId());
            }
        });
        if (!CollectionUtils.isEmpty(goodsIds)) {
            kmsAcceptanceGoodsMapper.deleteBatchIds(goodsIds);
        }
        List<KmsAcceptanceGoodsEntity> onlyList = Lists.newArrayList();
        onlyMap.forEach((k, v) -> {
            onlyList.add(v);
        });
        return onlyList;
    }

    /**
     * 数据转换
     *
     * @param acceptanceFormEntities
     * @param goodsEntities
     */
    public void transData(KmsAcceptanceFormEntity acceptanceFormEntity, List<KmsAcceptanceGoodsEntity> goodsEntities) {
        //封装转换数据信息
        TransDataVo transDataVo = new TransDataVo();
        transDataVo.setOrderType(KmsAdminEnum.OrderType.ACCEPTANCE.getValue());
        //头信息
        acceptanceFormEntity.setOrderStatusMsg("");
        TransDataStoreVo dataStoreVo = CrmBeanUtil.copy(acceptanceFormEntity, TransDataStoreVo.class);
        dataStoreVo.setSoldToPartyCode(null);
        dataStoreVo.setSoldToPartyName(null);
        dataStoreVo.setOrderStatusMsg("");
        dataStoreVo.setKaName(acceptanceFormEntity.getKaName());
        dataStoreVo.setKaOrderNumber(acceptanceFormEntity.getKaOrderNumber());
        transDataVo.setStoreVos(dataStoreVo);
        //商品信息
        goodsEntities.forEach(o -> {
            TransDataGoodsVo dataGoodsVo = CrmBeanUtil.copy(o, TransDataGoodsVo.class);
            dataGoodsVo.setCurUnitOrderQuantity(o.getCurUnitAcceptanceQuantity());
            dataGoodsVo.setKaOrderNumber(o.getKaOrderNumber());
            dataGoodsVo.setOrderStatusMsg("");
            dataGoodsVo.setKaName(o.getKaName());
            dataGoodsVo.setOrderDate(acceptanceFormEntity.getAcceptanceDate());
            transDataVo.getGoodsVos().add(dataGoodsVo);
        });
        //数据转换
        kmsTransDataService.transData(transDataVo);
        //结果数据处理
        resultProcessing(acceptanceFormEntity, goodsEntities, transDataVo);
    }

    /**
     * 转换结果处理
     *
     * @param acceptanceFormEntity
     * @param goodsEntities
     * @param transDataVo
     */
    private void resultProcessing(KmsAcceptanceFormEntity acceptanceFormEntity, List<KmsAcceptanceGoodsEntity> goodsEntities, TransDataVo transDataVo) {
        String orderNumber = acceptanceFormEntity.getOrderNumber();
        //转换结果信息
        TransDataStoreVo transDataStoreVo = transDataVo.getStoreVos();
        //门店处理
        BeanUtils.copyProperties(transDataStoreVo, acceptanceFormEntity, Arrays.stream(CrmBaseVo.class.getDeclaredFields())
                .map(Field::getName)
                .collect(Collectors.toList()).toArray(new String[]{}));
        //计算稽核日期
        if (!StringUtils.isEmpty(acceptanceFormEntity.getAcceptanceDate())) {
            Date acceptanceDate = DateUtil.getDateByFormat(acceptanceFormEntity.getAcceptanceDate(), DateUtil.DEFAULT_DAY_PATTERN);
            if (!ObjectUtils.isEmpty(transDataStoreVo.getTimeOfDay())) {
                Calendar cl = Calendar.getInstance();
                cl.setTime(acceptanceDate);
                cl.add(Calendar.DAY_OF_MONTH, transDataStoreVo.getTimeOfDay() * -1);
                acceptanceFormEntity.setAuditDate(DateUtil.format(cl.getTime(), DateUtil.DEFAULT_DAY_PATTERN));
            } else {
                acceptanceFormEntity.setAuditDate(DateUtil.format(acceptanceDate, DateUtil.DEFAULT_DAY_PATTERN));
            }
        }
        //确认转换状态
        String orderStatusMsg = acceptanceFormEntity.getOrderStatusMsg();
        //商品处理
        if (!CollectionUtils.isEmpty(goodsEntities)) {
            Map<String, TransDataGoodsVo> dataGoodsVoMap = transDataVo.getGoodsVos().stream()
                    .collect(Collectors.toMap(TransDataGoodsVo::getKaGoodsCode, Function.identity()));
            goodsEntities.forEach(goods -> {
                //商品行信息处理
                String kaGoodsCode = goods.getKaGoodsCode();
                TransDataGoodsVo transDataGoodsVo = dataGoodsVoMap.get(kaGoodsCode);
                BeanUtils.copyProperties(transDataGoodsVo, goods, Arrays.stream(CrmBaseVo.class.getDeclaredFields())
                        .map(Field::getName)
                        .collect(Collectors.toList()).toArray(new String[]{}));
                if (!StringUtils.isEmpty(goods.getOrderStatusMsg())) {
                    goods.setOrderStatus(KmsEnum.OrderStatus.S100.getValue());
                } else {
                    goods.setOrderStatus(KmsEnum.OrderStatus.S400.getValue());
                    goods.setOrderStatusMsg("转换成功");
                }
            });
            List<KmsAcceptanceGoodsEntity> errorList = goodsEntities.stream()
                    .filter(goods -> KmsEnum.OrderStatus.S100.getValue().equals(goods.getOrderStatus())).collect(Collectors.toList());
            if (!StringUtils.isEmpty(orderStatusMsg) || !CollectionUtils.isEmpty(errorList)) {
                acceptanceFormEntity.setOrderStatus(KmsEnum.OrderStatus.S100.getValue());
                if (!CollectionUtils.isEmpty(errorList) && !StringUtils.isEmpty(orderStatusMsg)) {
                    acceptanceFormEntity.setOrderStatusMsg(orderStatusMsg + "|商品行信息存在转换失败数据");
                } else if (!CollectionUtils.isEmpty(errorList) && StringUtils.isEmpty(orderStatusMsg)) {
                    acceptanceFormEntity.setOrderStatusMsg("商品行信息存在转换失败数据");
                }
            } else if (!KmsEnum.OrderStatus.S600.getValue().equals(acceptanceFormEntity.getOrderStatus())) {
                acceptanceFormEntity.setOrderStatus(KmsEnum.OrderStatus.S400.getValue());
            }
        } else {
            if (!StringUtils.isEmpty(orderStatusMsg)) {
                acceptanceFormEntity.setOrderStatus(KmsEnum.OrderStatus.S100.getValue());
                acceptanceFormEntity.setOrderStatusMsg(orderStatusMsg);
            } else if (!KmsEnum.OrderStatus.S600.getValue().equals(acceptanceFormEntity.getOrderStatus())) {
                acceptanceFormEntity.setOrderStatus(KmsEnum.OrderStatus.S400.getValue());
            }
        }
        /*if(StringUtils.isEmpty(o.getOrderStatusMsg()) && !KmsEnum.OrderStatus.S600.getValue().equals(o.getOrderStatus())){
           o.setOrderStatusMsg("转换成功");
        }*/
        if (StringUtils.isEmpty(acceptanceFormEntity.getOrderStatusMsg())) {
            acceptanceFormEntity.setOrderStatusMsg("转换成功");
        }
    }
}