package com.biz.crm.acceptanceform.service;

import com.biz.crm.acceptanceform.model.KmsAcceptanceGoodsEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.kms.acceptanceform.resp.KmsAcceptanceGoodsRespVo;
import com.biz.crm.nebular.kms.acceptanceform.req.KmsAcceptanceGoodsReqVo;

import java.util.Map;

/**
 * 验收单原始单据详情接口
 *
 * @author Gavin
 * @date 2021-05-12 18:03:22
 */
public interface IKmsAcceptanceGoodsService extends IService<KmsAcceptanceGoodsEntity> {

    /**
     * 列表
     * @param kmsAcceptanceGoodsReqVo
     * @return PageResult<KmsAcceptanceGoodsRespVo>
     */
    PageResult<KmsAcceptanceGoodsRespVo> findList(KmsAcceptanceGoodsReqVo kmsAcceptanceGoodsReqVo);

    /**
     * 查询
     * @param kmsAcceptanceGoodsReqVo
     * @return KmsAcceptanceGoodsRespVo
     */
    KmsAcceptanceGoodsRespVo query(KmsAcceptanceGoodsReqVo kmsAcceptanceGoodsReqVo);

    /**
     * 新增
     * @param kmsAcceptanceGoodsReqVo
     * @return
     */
    void save(KmsAcceptanceGoodsReqVo kmsAcceptanceGoodsReqVo);

    /**
     * 更新
     * @param kmsAcceptanceGoodsReqVo
     * @return
     */
    void update(KmsAcceptanceGoodsReqVo kmsAcceptanceGoodsReqVo);

    /**
     * 删除
     * @param kmsAcceptanceGoodsReqVo
     * @return
     */
    void deleteBatch(KmsAcceptanceGoodsReqVo kmsAcceptanceGoodsReqVo);

    /**
     * 启用
     * @param kmsAcceptanceGoodsReqVo
     * @return
     */
    void enableBatch(KmsAcceptanceGoodsReqVo kmsAcceptanceGoodsReqVo);

    /**
     * 禁用
     * @param kmsAcceptanceGoodsReqVo
     * @return
     */
    void disableBatch(KmsAcceptanceGoodsReqVo kmsAcceptanceGoodsReqVo);
}

