package com.biz.crm.confadmin.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.confadmin.service.IKmsAdminService;
import com.biz.crm.nebular.kms.confadmin.req.BsGrabInterfaceParamReqVo;
import com.biz.crm.nebular.kms.confadmin.req.TenantryDirectReqVo;
import com.biz.crm.nebular.kms.confadmin.req.TenantryDirectStoreReqVo;
import com.biz.crm.nebular.kms.confadmin.resp.BsGrabInterfaceParamRespVo;
import com.biz.crm.nebular.kms.confadmin.resp.KmsDirectOrderTypeRespVo;
import com.biz.crm.nebular.kms.confadmin.resp.KmsDirectStoreRespVo;
import com.biz.crm.nebular.kms.confadmin.resp.TenantryDirectRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * @Project crm
 * @PackageName com.biz.crm.admin
 * @ClassName KmsAdminController
 * @Author Gavin
 * @Date 2021/4/13 下午3:36
 * @Description kms后台配置获取
 */
@Slf4j
@RestController
@RequestMapping("/kmsAdmin")
@Api(tags = "KMS后台管理配置")
public class KmsAdminController {

    @Resource
    private IKmsAdminService kmsAdminService;

    /**
     * 获取客户开通商超信息
     */
    @ApiOperation(value = "获取客户开通商超（直营体系）信息")
    @PostMapping("/tenantry/direct/list")
    @CrmLog
    public Result<PageResult<TenantryDirectRespVo>> list(@RequestBody TenantryDirectReqVo params) {
        PageResult<TenantryDirectRespVo> result = kmsAdminService.findTenantryDirectList(params);
        return Result.ok(result);
    }

    /**
     * 获取客户开通商超（直营体系）门店信息
     */
    @ApiOperation(value = "获取客户开通商超（直营体系）门店信息")
    @PostMapping("/tenantry/direct/store/list")
    @CrmLog
    public Result<PageResult<KmsDirectStoreRespVo>> storeList(@RequestBody TenantryDirectStoreReqVo params) {
        PageResult<KmsDirectStoreRespVo> result = kmsAdminService.findTenantryDirectStoreList(params);
        return Result.ok(result);
    }

    /**
     * 获取商超单据类型
     */
    @ApiOperation(value = "获取客户开通商超（直营体系）单据类型信息")
    @PostMapping("/tenantry/direct/orderType/list")
    @CrmLog
    public Result<List<KmsDirectOrderTypeRespVo>> orderTypeList(@RequestBody TenantryDirectReqVo params) {
        List<KmsDirectOrderTypeRespVo> result = kmsAdminService.findTenantryDirectOrderTypeList(params);
        return Result.ok(result);
    }

    /**
     * 获取商超单据类型
     */
    @ApiOperation(value = "获取客户开通商超（直营体系）参数管理单据类型信息")
    @PostMapping("/tenantry/direct/param/orderType/list")
    @CrmLog
    public Result<List<KmsDirectOrderTypeRespVo>> paramOrderTypeList(@RequestBody TenantryDirectReqVo params) {
        List<KmsDirectOrderTypeRespVo> result = kmsAdminService.paramOrderTypeList(params);
        return Result.ok(result);
    }

    /**
     * 查询抓单参数
     */
    @ApiOperation(value = "查询抓单参数")
    @PostMapping("/grab/order/params")
    @CrmLog
    public Result<List<BsGrabInterfaceParamRespVo>> storeList(@RequestBody BsGrabInterfaceParamReqVo params) {
        List<BsGrabInterfaceParamRespVo> result = kmsAdminService.findGrabOrderParams(params);
        return Result.ok(result);
    }
}