package com.biz.crm.confadmin.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.confadmin.service.IKmsDirectSystemService;
import com.biz.crm.nebular.kms.confadmin.req.KmsDirectSystemReqVo;
import com.biz.crm.nebular.kms.confadmin.resp.KmsDirectSystemRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 商超信息
 *
 * @author Gavin
 * @date 2021-05-06 13:51:45
 */
@Slf4j
@RestController
@RequestMapping("/kmsdirectsystem")
@Api(tags = "KMS后台商超信息")
public class KmsDirectSystemController {
    @Autowired
    private IKmsDirectSystemService kmsDirectSystemService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<KmsDirectSystemRespVo>> list(@RequestBody KmsDirectSystemReqVo kmsDirectSystemReqVo) {
        PageResult<KmsDirectSystemRespVo> result = kmsDirectSystemService.findList(kmsDirectSystemReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @GetMapping("/query")
    @CrmLog
    public Result<KmsDirectSystemRespVo> query(@RequestParam(value = "id", required = false) String id) {
        KmsDirectSystemRespVo respVo = kmsDirectSystemService.query(id);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody KmsDirectSystemReqVo kmsDirectSystemReqVo) {
        kmsDirectSystemService.save(kmsDirectSystemReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody KmsDirectSystemReqVo kmsDirectSystemReqVo) {
        kmsDirectSystemService.update(kmsDirectSystemReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        kmsDirectSystemService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        kmsDirectSystemService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        kmsDirectSystemService.disableBatch(ids);
        return Result.ok("禁用成功");
    }

    /**
     * 根据直营体系查询商超列表
     */
    @ApiOperation(value = "根据直营体系查询商超列表")
    @PostMapping("/findDirectSystemList")
    @CrmLog
    public Result<PageResult<KmsDirectSystemRespVo>> findDirectSystemList(@RequestBody KmsDirectSystemReqVo reqVo){
        PageResult<KmsDirectSystemRespVo> respVos = kmsDirectSystemService.findDirectSystemList(reqVo);
        return Result.ok(respVos);
    }
}
