package com.biz.crm.confadmin.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.confadmin.service.IKmsDirectThreadService;
import com.biz.crm.nebular.kms.confadmin.req.KmsDirectThreadReqVo;
import com.biz.crm.nebular.kms.confadmin.resp.KmsDirectThreadRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 商超单据抓取方式
 *
 * @author Gavin
 * @date 2021-05-06 15:12:00
 */
@Slf4j
@RestController
@RequestMapping("/kmsdirectthread")
@Api(tags = "KMS后台商超单据抓取方式")
public class KmsDirectThreadController {
    @Autowired
    private IKmsDirectThreadService kmsDirectThreadService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<KmsDirectThreadRespVo>> list(@RequestBody KmsDirectThreadReqVo kmsDirectThreadReqVo) {
        PageResult<KmsDirectThreadRespVo> result = kmsDirectThreadService.findList(kmsDirectThreadReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @GetMapping("/query")
    @CrmLog
    public Result<KmsDirectThreadRespVo> query(@RequestParam(value = "id", required = false) String id) {
        KmsDirectThreadRespVo respVo = kmsDirectThreadService.query(id);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody KmsDirectThreadReqVo kmsDirectThreadReqVo) {
        kmsDirectThreadService.save(kmsDirectThreadReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody KmsDirectThreadReqVo kmsDirectThreadReqVo) {
        kmsDirectThreadService.update(kmsDirectThreadReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        kmsDirectThreadService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        kmsDirectThreadService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        kmsDirectThreadService.disableBatch(ids);
        return Result.ok("禁用成功");
    }
}
