package com.biz.crm.confadmin.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.confadmin.model.KmsDirectOrderTypeEntity;
import com.biz.crm.nebular.kms.confadmin.req.KmsDirectOrderTypeReqVo;
import com.biz.crm.nebular.kms.confadmin.req.TenantryDirectReqVo;
import com.biz.crm.nebular.kms.confadmin.resp.KmsDirectOrderTypeRespVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 商超支持抓取单据类型信息
 *
 * @author Gavin
 * @date 2021-05-06 16:54:55
 */
public interface KmsDirectOrderTypeMapper extends BaseMapper<KmsDirectOrderTypeEntity> {
    /**
     * 列表
     *
     * @param page
     * @param kmsDirectOrderTypeReqVo
     * @return
     */
    List<KmsDirectOrderTypeRespVo> findList(Page<KmsDirectOrderTypeRespVo> page, @Param("vo") KmsDirectOrderTypeReqVo kmsDirectOrderTypeReqVo);

    /**
     * 获取客户开通商超（直营体系）单据类型信息
     * @param params
     * @return
     */
    List<KmsDirectOrderTypeRespVo> findOrderTypeList(@Param("vo") TenantryDirectReqVo params);
}
