package com.biz.crm.confadmin.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.confadmin.model.KmsDirectStoreEntity;
import com.biz.crm.nebular.kms.confadmin.req.KmsDirectStoreReqVo;
import com.biz.crm.nebular.kms.confadmin.req.TenantryDirectStoreReqVo;
import com.biz.crm.nebular.kms.confadmin.resp.KmsDirectStoreRespVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 商超门店管理
 *
 * @author Gavin
 * @date 2021-05-06 14:03:40
 */
public interface KmsDirectStoreMapper extends BaseMapper<KmsDirectStoreEntity> {
    /**
     * 列表
     *
     * @param page
     * @param kmsDirectStoreReqVo
     * @return
     */
    List<KmsDirectStoreRespVo> findList(Page<KmsDirectStoreRespVo> page, @Param("vo") KmsDirectStoreReqVo kmsDirectStoreReqVo);

    /**
     * 获取客户开通商超（直营体系）门店信息
     * @param page
     * @param params
     * @return
     */
    List<KmsDirectStoreRespVo> findDirectStoreList(Page<KmsDirectStoreRespVo> page, @Param("vo") TenantryDirectStoreReqVo params);
}
