package com.biz.crm.confadmin.service;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.kms.confadmin.req.BsGrabInterfaceParamReqVo;
import com.biz.crm.nebular.kms.confadmin.req.TenantryDirectReqVo;
import com.biz.crm.nebular.kms.confadmin.req.TenantryDirectStoreReqVo;
import com.biz.crm.nebular.kms.confadmin.resp.BsGrabInterfaceParamRespVo;
import com.biz.crm.nebular.kms.confadmin.resp.KmsDirectOrderTypeRespVo;
import com.biz.crm.nebular.kms.confadmin.resp.KmsDirectStoreRespVo;
import com.biz.crm.nebular.kms.confadmin.resp.TenantryDirectRespVo;

import java.util.List;

/**
 * @Description kms后台管理接口
 * @Author Gavin
 * @Date Created in 2021/4/13 下午4:01
 */
public interface IKmsAdminService {

    /**
     * 获取客户开通商超（直营体系）信息
     * @return
     */
    PageResult<TenantryDirectRespVo> findTenantryDirectList(TenantryDirectReqVo params);

    /**
     * 获取客户开通商超（直营体系）门店信息
     * @param params
     * @return
     */
    PageResult<KmsDirectStoreRespVo> findTenantryDirectStoreList(TenantryDirectStoreReqVo params);

    /**
     * 获取客户开通商超（直营体系）单据类型信息
     * @param params
     * @return
     */
    List<KmsDirectOrderTypeRespVo> findTenantryDirectOrderTypeList(TenantryDirectReqVo params);

    /**
     * 查询抓单参数
     * @param params
     * @return
     */
    List<BsGrabInterfaceParamRespVo> findGrabOrderParams(BsGrabInterfaceParamReqVo params);

    /**
     * 获取客户开通商超（直营体系）参数管理单据类型信息
     * @param params
     * @return
     */
    List<KmsDirectOrderTypeRespVo> paramOrderTypeList(TenantryDirectReqVo params);
}