package com.biz.crm.confadmin.service.impl;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.PageResult;
import com.biz.crm.confadmin.mapper.*;
import com.biz.crm.confadmin.service.IKmsAdminService;
import com.biz.crm.config.KmsConfig;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.kms.KmsAdminEnum;
import com.biz.crm.nebular.kms.confadmin.base.BaseClassifyConstants;
import com.biz.crm.nebular.kms.confadmin.req.*;
import com.biz.crm.nebular.kms.confadmin.resp.*;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.PageUtil;
import com.google.common.collect.Lists;

import lombok.extern.slf4j.Slf4j;

/**
 * @Project crm
 * @PackageName com.biz.crm.confadmin.service.impl
 * @ClassName KmsAdminServiceImpl
 * @Author Gavin
 * @Date 2021/4/13 下午4:02
 * @Description kms后台管理接口实现
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "KmsAdminServiceImpl")
public class KmsAdminServiceImpl implements IKmsAdminService {

    @Autowired
    private KmsConfig kmsConfig;

    @Resource
    private KmsDirectSystemMapper kmsDirectSystemMapper;

    @Resource
    private KmsDirectStoreMapper kmsDirectStoreMapper;

    @Resource
    private KmsDirectOrderTypeMapper kmsDirectOrderTypeMapper;

    @Resource
    private KmsInterfaceParamMapper kmsInterfaceParamMapper;

    @Resource
    private KmsInterfaceParamOptionMapper kmsInterfaceParamOptionMapper;

    @Resource
    private KmsInterfaceSubParamOptionMapper kmsInterfaceSubParamOptionMapper;

    /**
     * 获取客户开通商超（直营体系）信息
     * @return
     */
    @Override
    public PageResult<TenantryDirectRespVo> findTenantryDirectList(TenantryDirectReqVo params) {
        Page<KmsDirectStoreRespVo> page = PageUtil.buildPage(params.getPageNum(), params.getPageSize());
        List<TenantryDirectRespVo> list = kmsDirectSystemMapper.findDirectList(page, params);
        return PageResult.<TenantryDirectRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 获取客户开通商超（直营体系）门店信息
     * @param params
     * @return
     */
    @Override
    public PageResult<KmsDirectStoreRespVo> findTenantryDirectStoreList(TenantryDirectStoreReqVo params) {
        AssertUtils.isNotEmpty(params.getDirectId(),"商超ID[directId]不能为空");
        Page<KmsDirectStoreRespVo> page = PageUtil.buildPage(params.getPageNum(), params.getPageSize());
        List<KmsDirectStoreRespVo> list = kmsDirectStoreMapper.findDirectStoreList(page, params);
        return PageResult.<KmsDirectStoreRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 获取客户开通商超（直营体系）单据类型信息
     * @param params
     * @return
     */
    @Override
    public List<KmsDirectOrderTypeRespVo> findTenantryDirectOrderTypeList(TenantryDirectReqVo params) {
        AssertUtils.isNotEmpty(params.getDirectId(),"商超ID[directId]不能为空");
        return kmsDirectOrderTypeMapper.findOrderTypeList(params);
    }

    /**
     * 获取客户开通商超（直营体系）参数管理单据类型信息
     * @param params
     * @return
     */
    @Override
    public List<KmsDirectOrderTypeRespVo> paramOrderTypeList(TenantryDirectReqVo params) {
        AssertUtils.isNotEmpty(params.getDirectId(),"商超ID[directId]不能为空");
        List<KmsDirectOrderTypeRespVo> orderTypeList = kmsDirectOrderTypeMapper.findOrderTypeList(params);
        List<KmsDirectOrderTypeRespVo> orderTypeRespVos = Lists.newArrayList();
        KmsDirectOrderTypeRespVo respVo = new KmsDirectOrderTypeRespVo();
        respVo.setOrderType(KmsAdminEnum.OrderType.LOGIN_ORDER_TYPE.getValue());
        respVo.setOrderTypeName(KmsAdminEnum.OrderType.LOGIN_ORDER_TYPE.getDescription());
        orderTypeRespVos.add(respVo);
        orderTypeList.forEach(o -> {
            KmsDirectOrderTypeRespVo orderTypeRespVo = new KmsDirectOrderTypeRespVo();
            orderTypeRespVo.setOrderType(o.getOrderType());
            orderTypeRespVo.setOrderTypeName(o.getOrderTypeName());
            orderTypeRespVos.add(orderTypeRespVo);
        });
        return orderTypeRespVos;
    }

    /**
     * 查询抓单参数
     * @param params
     * @return
     */
    @Override
    public List<BsGrabInterfaceParamRespVo> findGrabOrderParams(BsGrabInterfaceParamReqVo params) {
        AssertUtils.isNotEmpty(params.getDirectId(),"商超ID不能为空");
        AssertUtils.isNotEmpty(params.getOrderType(),"单据类型不能为空");
        List<String> orderTypes = Lists.newArrayList();
        orderTypes.add(params.getOrderType());
        orderTypes.add(KmsAdminEnum.OrderType.LOGIN_ORDER_TYPE.getValue());
        params.setOrderTypes(orderTypes);
        params.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        params.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        List<BsGrabInterfaceParamRespVo> respVos = kmsInterfaceParamMapper.findGrabOrderParams(params);
        //不为空查询属性以及子参数
        if(!CollectionUtils.isEmpty(respVos)){
            //参数ID集合
            List<String> fields = respVos.stream().map(BsGrabInterfaceParamRespVo::getFieldId)
                    .collect(Collectors.toList());
            //查询属性
            KmsInterfaceParamOptionReqVo optionReqVo = new KmsInterfaceParamOptionReqVo();
            optionReqVo.setFieldIds(fields);
            List<BsGrabInterfaceParamOptionRespVo> optionRespVos = kmsInterfaceParamOptionMapper
                    .findOptionsByFieldIds(optionReqVo);
            Map<String, List<BsGrabInterfaceParamOptionRespVo>> optionMap = optionRespVos.stream()
                    .collect(Collectors.groupingBy(BsGrabInterfaceParamOptionRespVo::getFieldId));
            //查询子参数
            KmsInterfaceSubParamOptionReqVo subParamOptionReqVo = new KmsInterfaceSubParamOptionReqVo();
            subParamOptionReqVo.setFieldIds(fields);
            List<BsGrabInterfaceSubParamOptionRespVo> subParamOptionRespVos = kmsInterfaceSubParamOptionMapper
                    .findSubParamOptionsByFieldIds(subParamOptionReqVo);
            Map<String, List<BsGrabInterfaceSubParamOptionRespVo>> subParamOptionMap = subParamOptionRespVos.stream()
                    .collect(Collectors.groupingBy(BsGrabInterfaceSubParamOptionRespVo::getFieldId));
            respVos.forEach(o -> {
                //日期控件特殊处理
                if (BaseClassifyConstants.FieldClassify.DATE.getValue().equals(o.getFieldClassify())
                        || BaseClassifyConstants.FieldClassify.DATERANGE.getValue().equals(o.getFieldClassify())) {
                    List<BsGrabInterfaceParamOptionRespVo> dateOptions = optionMap.get(o.getFieldId());
                    dateOptions.forEach(dos -> {
                        Calendar cl = Calendar.getInstance();
                        cl.add(Calendar.DAY_OF_MONTH, Integer.parseInt(dos.getOptionValue()) * -1);
                        dos.setOptionStartDate(DateUtil.getYYYYMMDD(cl.getTime()));
                        if(!BaseClassifyConstants.FieldClassify.DATE.getValue().equals(o.getFieldClassify())){
                            dos.setOptionEndDate(DateUtil.getYYYYMMDD(new Date()));
                        }
                    });
                    o.setOptions(dateOptions);
                }else{
                    o.setOptions(optionMap.get(o.getFieldId()));
                }
                o.setSubOptions(subParamOptionMap.get(o.getFieldId()));
            });
        }
        return respVos;
    }
}