package com.biz.crm.confadmin.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.TpmGlobalDictConstants;
import com.biz.crm.confadmin.mapper.KmsDirectOrderTypeMapper;
import com.biz.crm.confadmin.mapper.KmsDirectStoreMapper;
import com.biz.crm.confadmin.mapper.KmsDirectSystemMapper;
import com.biz.crm.confadmin.model.KmsDirectOrderTypeEntity;
import com.biz.crm.confadmin.model.KmsDirectSystemEntity;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.nebular.kms.confadmin.req.KmsDirectSystemReqVo;
import com.biz.crm.nebular.kms.confadmin.resp.KmsDirectSystemRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author maoshen
 * @date 2021/5/6.
 */
@Component
@Slf4j
public class KmsDirectSystemHelper {

    @Resource
    private KmsDirectSystemMapper directSystemMapper;

    @Resource
    private KmsDirectStoreMapper directStoreMapper;

    @Resource
    private KmsDirectOrderTypeMapper directOrderTypeMapper;

    /**
     * 商超体系新增 或编辑
     * 数据检验
     *
     * @param reqVo
     */
    public void paramCheck(KmsDirectSystemReqVo reqVo) {
        // 检验数据是否填写。
        AssertUtils.isNotEmpty(reqVo.getDirectName(), "商超名称不能为空");
        AssertUtils.isNotEmpty(reqVo.getVendorSystemUrl(), "商超网址不能为空");
        reqVo.setVendorSystemUrl(reqVo.getVendorSystemUrl().trim());
        AssertUtils.isNotEmpty(reqVo.getOrderTypeVos(), "支持单据类型不能为空");
        // 不允许重复选择
        Set<String> orderTypes = Sets.newHashSet();
        reqVo.getOrderTypeVos().forEach(x -> {
            AssertUtils.isNotEmpty(x.getOrderType(), "单据类型编码[orderType]不能为空");
            AssertUtils.isNotEmpty(x.getOrderTypeName(), "单据类型名称[orderTypeName]不能为空");
            if (orderTypes.contains(x.getOrderType())) {
                throw new BusinessException(x.getOrderType() + "的单据类型不可重复选择");
            }
            orderTypes.add(x.getOrderType());
        });
        LambdaQueryWrapper<KmsDirectSystemEntity> wrapper = Wrappers.<KmsDirectSystemEntity>lambdaQuery();
        if (StringUtils.isNotBlank(reqVo.getId())) {
            wrapper.ne(KmsDirectSystemEntity::getId, reqVo.getId());
        }
        wrapper.eq(KmsDirectSystemEntity::getDirectName, reqVo.getDirectName());
        wrapper.eq(KmsDirectSystemEntity::getVendorSystemUrl, reqVo.getVendorSystemUrl());
        wrapper.eq(KmsDirectSystemEntity::getDelFlag, CrmDelFlagEnum.NORMAL.getCode());
        if (CollectionUtils.isNotEmpty(directSystemMapper.selectList(wrapper))) {
            throw new BusinessException("该商超系统已经存在");
        }
    }

    /**
     * 新增 或者 修改 支持单据类型表
     *
     * @param reqVo
     */
    public List<KmsDirectOrderTypeEntity> buildDirectOrderType(KmsDirectSystemReqVo reqVo) {
        List<KmsDirectOrderTypeEntity> entities = Lists.newArrayList();
        reqVo.getOrderTypeVos().forEach(x -> {
            KmsDirectOrderTypeEntity entity = CrmBeanUtil.copy(x, KmsDirectOrderTypeEntity.class);
            entity.setDirectId(reqVo.getId());
            entities.add(entity);
        });
        return entities;
    }

    /**
     * 转换列表数据
     *
     * @param list
     */
    public void convertData(List<KmsDirectSystemRespVo> list) {

        if (CollectionUtils.isNotEmpty(list)) {
            Set<String> idSet = list.stream().map(KmsDirectSystemRespVo::getId).collect(Collectors.toSet());
            List<KmsDirectOrderTypeEntity> orderTypeEntityList = directOrderTypeMapper
                    .selectList(Wrappers.<KmsDirectOrderTypeEntity>lambdaQuery().in(KmsDirectOrderTypeEntity::getDirectId, idSet)
                            .eq(KmsDirectOrderTypeEntity::getDelFlag,CrmDelFlagEnum.NORMAL.getCode()));
            // 转map
            Map<String, List<KmsDirectOrderTypeEntity>> orderTypeMap = orderTypeEntityList.stream()
                    .collect(Collectors.groupingBy(KmsDirectOrderTypeEntity::getDirectId));
            list.forEach(x -> {
                List<KmsDirectOrderTypeEntity> orderTypeEntities = orderTypeMap.get(x.getId());
                List<String> orderTypeNames = orderTypeEntities.stream().map(KmsDirectOrderTypeEntity::getOrderTypeName)
                        .collect(Collectors.toList());
                x.setOrderTypeStr(orderTypeNames.stream().collect(Collectors.joining(",")));
            });
        }
    }

    /**
     * 转换数据  map
     *
     * @return
     */
    public Map<String, Map<String, String>> getDictMaps() {
        List<String> dictCodes = Lists.newArrayList();
        dictCodes.add(TpmGlobalDictConstants.ENABLE_STATUS);
        //查询字典数据
        return DictUtil.getDictValueMapsByCodes(dictCodes);
    }
}
