package com.biz.crm.config;

import org.apache.commons.codec.binary.Base64;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.phase.Phase;
import org.apache.cxf.transport.http.AbstractHTTPDestination;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletRequest;
import javax.xml.soap.SOAPException;

/**
 * @Project crm-core
 * @PackageName com.biz.crm.interceptor
 * @ClassName AuthInterceptor
 * @Author Gavin
 * @Date 2021/10/22 上午11:24
 * @Description web service鉴权
 */
public class AuthInterceptor extends AbstractPhaseInterceptor<SoapMessage> {

    private static final String BASIC_PREFIX = "Basic ";

    private String USERNAME;
    private String PASSWORD;

    public AuthInterceptor(String username, String password) {
        // 定义在什么阶段进行拦截
        super(Phase.PRE_PROTOCOL);
        this.USERNAME = username;
        this.PASSWORD = password;
    }

    @Override
    public void handleMessage(SoapMessage soapMessage) throws Fault {
        // 获取HttpServletRequest
        HttpServletRequest request = (HttpServletRequest) soapMessage.get(AbstractHTTPDestination.HTTP_REQUEST);

        String auth = request.getHeader("Authorization");

        if (auth == null) {
            SOAPException exception = new SOAPException("Authorization 授权信息为空！");
            throw new Fault(exception);
        }
        if (!auth.startsWith(BASIC_PREFIX)) {
            SOAPException exception = new SOAPException("Authorization 非baisc验证");
            throw new Fault(exception);
        }
        // 合法的baisc格式为username:password  例如：admin:123456
        String plaintext = new String(Base64.decodeBase64(auth.substring(BASIC_PREFIX.length())));
        if (StringUtils.isEmpty(plaintext) || !plaintext.contains(":")) {
            SOAPException exception = new SOAPException("Authorization 非baisc验证");
            throw new Fault(exception);
        }

        String[] usernameAndPass = plaintext.split(":");
        String username = usernameAndPass[0];
        String password = usernameAndPass[1];
        if (!USERNAME.equals(username) || !PASSWORD.equals(password)) {
            SOAPException exception = new SOAPException("用户名或密码不正确！");
            throw new Fault(exception);
        }
    }
}