package com.biz.crm.config;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

/**
 * @Project crm
 * @PackageName com.biz.crm.config
 * @ClassName KmsSapConfig
 * @Author Gavin
 * @Date 2021/6/1 上午10:01
 * @Description sap交互信息
 */
@Getter
@Setter
@Configuration
@ConfigurationProperties(prefix = "kms.sap")
public class KmsSapConfig {

    /**
     * 订单推送SAP地址
     */
    private String sendSapAddr;

    /**
     * 订单推送SAP地址
     */
    private String sendSapUserName;

    /**
     * 订单推送SAP地址
     */
    private String sendSapPassWord;

    /**
     * sap hana地址
     */
    private String sapHanaAddr;

    /**
     * sap hana用户名
     */
    private String sapHanaUserName;

    /**
     * sap hana密码
     */
    private String sapHanaPassWord;
}