package com.biz.crm.constant;

/**
 * @Project crm
 * @PackageName com.biz.crm.constant
 * @ClassName KmsParmConstant
 * @Author Gavin
 * @Date 2021/5/10 下午3:17
 * @Description 抓单参数常量
 */
public class KmsParmConstant {

    /**
     * 规则公用字段（请求JSONObject对象）
     */
    public static final String PARAM_REQ_OBJECT = "reqObject";
    /**
     * 规则公用字段（返回JSONObject对象）
     */
    public static final String PARAM_RESP_OBJECT = "respObject";

    /**
     * 请求参数字段设置（主体）
     */
    public static final String GRPC_REQ_BODY = "body";
    /**
     * 请求参数字段设置（扩展参数）
     */
    public static final String GRPC_REQ_EXTEND_ARGS = "extend_args";
    /**
     * 请求参数字段设置（请求体）
     */
    public static final String GRPC_REQ_REQ_PARAM = "req_parm";
    /**
     * 请求参数字段设置（请求体扩展字段）
     */
    public static final String GRPC_REQ_EXTEND_PARAM = "extend_parm";

    /**
     * Grpc返回参数字段设置（返回结果）
     */
    public static final String GRPC_RESP_RESULT = "result";
    /**
     * Grpc返回参数字段设置（返回结果具体表单内容）
     */
    public static final String GRPC_RESP_FORM = "form";
    /**
     * Grpc返回参数字段设置（ai错误信息）
     */
    public static final String GRPC_RESP_ERROR_MSG = "error_msg";
    /**
     * Grpc返回参数字段设置（登录成功标识：1-成功，其他-失败）
     */
    public static final String GRPC_RESP_LOGIN = "login";
    /**
     * Grpc返回参数字段设置（抓单失败原因）
     */
    public static final String GRPC_RESP_ERRORS = "errors";

    /**
     * Grpc返回参数字段设置（返回信息）
     */
    public static final String GRPC_RESP_INFO = "info";
    /**
     * Grpc返回参数字段设置（单据总数）
     */
    public static final String GRPC_RESP_TOTAL_NUM = "total_num";
    /**
     * Grpc返回参数字段设置（单据总数范围最小值）
     */
    public static final String GRPC_RESP_TOTAL_MIN = "total_min";
    /**
     * Grpc返回参数字段设置（单据总数范围最大值）
     */
    public static final String GRPC_RESP_TOTAL_MAX = "total_max";

    /**
     * Grpc返回参数字段设置（丢失单据数量范围最小值）
     */
    public static final String GRPC_RESP_LOSE_MIN = "lose_min";
    /**
     * Grpc返回参数字段设置（丢失单据数量范围最大值）
     */
    public static final String GRPC_RESP_LOSE_MAX = "lose_max";
    /**
     * Grpc返回参数字段设置（抓取的单据数量）
     */
    public static final String GRPC_RESP_CRAWLING_NUM = "crawling_num";
    /**
     * Grpc返回参数字段设置（成功的单据数量）
     */
    public static final String GRPC_RESP_SUCCEED = "succeed";

    /**
     * Grpc返回参数字段设置（失败的单据数量）
     */
    public static final String GRPC_RESP_FAILED = "failed";

    /**
     * Grpc返回参数字段设置（重复的单据数量）
     */
    public static final String GRPC_RESP_DITTO = "ditto";


    //是否全部门店
    public static final String KMS_ALL_STORE = "kms_all_store";
    //门店编码
    public static final String STORE_CODE = "code";
    //门店名称
    public static final String STORE_NAME = "name";
    //抓单参数门店键
    public static final String SOLD_TO_PARTY = "sold_to_party";
    //商超名称
    public static final String KA_NAME = "ka_name";
    //抓单单据类型描述
    public static final String DOC = "doc";
    //登录用户名
    public static final String USER_NAME = "username";
    //登录密码
    public static final String PASS_WORD = "password";
    //ka-flag
    public static final String KMS_PATH_TYPE = "KMS_path_type";
    public static final String KA_FLAG = "ka_flag";
    //kms-id
    public static final String KMS_IP = "kms_ip";
    //抓单规则创建人
    public static final String PRINCIPAL_ID = "principal_id";
    //'force'：'0' 表示会md5去重(自动抓单强制覆盖为md5去重)
    public static final String FORCE = "force";
    //租户ID
    public static final String TENANTRY_ID = "tenantry_id";
    //抓单规则名称
    public static final String RULE_NAME = "rule_name";
    //直营体系ID
    public static final String DIRECT_SYSTEM_ID = "direct_system_id";
    //单据类型ID
    public static final String BS_INVOICE_ID = "bs_invoice_id";
    //track_id
    public static final String TRACK_ID = "track_id";
    //抓取类型 自动/手动
    public static final String STYLE = "style";
    //操作用户
    public static final String NICK_NAME = "nick_name";
    //抓取数据唯一ID
    public static final String RESP_DATA_ID = "resp_data_id";
}