package com.biz.crm.finance.funcation;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.acceptanceform.mapper.KmsAcceptanceFormMapper;
import com.biz.crm.acceptanceform.model.KmsAcceptanceFormEntity;
import com.biz.crm.acceptanceform.service.IKmsAcceptanceStatusRecordService;
import com.biz.crm.common.PageResult;
import com.biz.crm.constant.KmsConstant;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.kms.KmsAuditConditionEnum;
import com.biz.crm.eunm.kms.KmsEnum;
import com.biz.crm.finance.annotation.KmsFunction;
import com.biz.crm.finance.funcation.base.BaseAuditFunction;
import com.biz.crm.finance.mapper.KmsAuditFormMapper;
import com.biz.crm.finance.mapper.KmsAuditMatchRelationMapper;
import com.biz.crm.finance.model.KmsAcceptanceMatchRelationEntity;
import com.biz.crm.finance.model.KmsAuditFormEntity;
import com.biz.crm.finance.model.KmsAuditMatchRelationEntity;
import com.biz.crm.finance.service.IKmsAcceptanceMatchRelationService;
import com.biz.crm.kaproduct.mapper.KmsTenantryDirectProductMapper;
import com.biz.crm.nebular.kms.acceptanceform.req.KmsAcceptanceFormReqVo;
import com.biz.crm.nebular.kms.acceptanceform.resp.KmsAuditAcceptanceFormRespVo;
import com.biz.crm.nebular.kms.finance.req.KmsAuditFormReqVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditFormRespVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditTemplateDirectRespVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditTemplateRespVo;
import com.biz.crm.nebular.kms.kaproduct.req.KmsTenantryDirectProductReqVo;
import com.biz.crm.nebular.kms.kaproduct.resp.KmsTenantryDirectProductRespVo;
import com.biz.crm.nebular.kms.sap.resp.KmsSapInvoiceRespVo;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.KmsUtils;
import com.biz.crm.util.PageUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Project crm
 * @PackageName com.biz.crm.finance.function
 * @ClassName KmsPdsoFunction
 * @Author Gavin
 * @Date 2021/6/22 上午10:53
 * @Description 订单+门店+商品
 */

@KmsFunction(code = KmsAuditConditionEnum.PDSO, name = "门店+商品+订单号", desc = "稽核条件")
@Slf4j
public class KmsPdsoFunction implements BaseAuditFunction {
    @Resource
    private KmsAuditFormMapper kmsAuditFormMapper;

    @Resource
    private KmsAuditMatchRelationMapper kmsAuditMatchRelationMapper;

    @Resource
    private KmsAcceptanceFormMapper kmsAcceptanceFormMapper;

    @Resource
    private IKmsAcceptanceMatchRelationService kmsAcceptanceMatchRelationService;

    @Resource
    private IKmsAcceptanceStatusRecordService kmsAcceptanceStatusRecordService;

    @Resource
    private KmsTenantryDirectProductMapper kmsTenantryDirectProductMapper;

    /**
     * 数据汇总
     *
     * @param e
     * @param a
     */
    @Override
    public void summary(List<KmsSapInvoiceRespVo> invoice, KmsAuditTemplateRespVo a, KmsAuditTemplateDirectRespVo templateDirectRespVo, List<KmsAuditFormEntity> auditFormEntities, List<KmsAuditMatchRelationEntity> relationEntities) {
        //invoicepool = invoicepool.stream().filter(o -> !StringUtils.isEmpty(o.getBstkd())).collect(Collectors.toList());
        KmsSapInvoiceRespVo e = invoice.get(0);
        //根据公司+门店+商品+订单号 查询汇总数据信息
        Map<String, List<KmsSapInvoiceRespVo>> summaryInvStoreMap = Maps.newHashMap();
        Map<String, KmsAuditFormEntity> summaryAuditStoreMap = Maps.newHashMap();
        //订单号集合
        List<String> bstkdList = Lists.newArrayList();
        invoice.forEach(invo -> {
            invo.setKunnr(KmsUtils.removeFrontZero(invo.getKunnr()));
            invo.setKunag(KmsUtils.removeFrontZero(invo.getKunag()));
            invo.setMatnr(KmsUtils.removeFrontZero(invo.getMatnr()));
            //汇总纬度(Y 门店——N 售达方)
            invo.setIsStore(YesNoEnum.yesNoEnum.Y.getValue());
            //数据汇总 门店、物料、订单号
            if (StringUtils.isEmpty(invo.getBstkd())) {
                invo.setBstkd("DC" + invo.getFkdat());
            }
            bstkdList.add(invo.getBstkd());
            String storeKey = invo.getKunnr() + "-" + invo.getMatnr() + "-" + invo.getBstkd();
            List<KmsSapInvoiceRespVo> invoS = summaryInvStoreMap.get(storeKey);
            if (CollectionUtils.isEmpty(invoS)) {
                invoS = Lists.newArrayList();
            }
            invoS.add(invo);
            summaryInvStoreMap.put(storeKey, invoS);
        });
        String templateId = a.getId();
        //查询已汇总数据
        KmsAuditFormReqVo params = new KmsAuditFormReqVo();
        params.setBukrs(e.getBukrs());
        params.setOrgCode(e.getOrgCode());
        params.setAuditTemplateId(templateId);
        params.setBsDirectSystemId(a.getBsDirectSystemId());
        params.setBstkdList(bstkdList.stream().distinct().collect(Collectors.toList()));
        List<KmsAuditFormEntity> afeEntities = kmsAuditFormMapper.findListByParams(params);
        afeEntities.forEach(audit -> {
            String storeKey = audit.getStoreCode() + "-" + audit.getSapMaterielCode() + "-" + audit.getKaOrderNumber();
            summaryAuditStoreMap.put(storeKey, audit);
        });
        //数据处理
        //summaryInvStoreMap、summaryInvSolMap、summaryAuditStoreMap、summaryAuditSolMap
        //门店纬度
        summaryInvStoreMap.forEach((k, v) -> {
            KmsAuditFormEntity afe = summaryAuditStoreMap.get(k);
            if (ObjectUtils.isEmpty(afe)) {
                afe = new KmsAuditFormEntity();
                KmsSapInvoiceRespVo i = v.get(0);
                buildAuditForm(afe, i, templateDirectRespVo);
                afe.setProductType(i.getMtpos());
                afe.setDirectName(a.getBsDirectSystemName());
                afe.setBsDirectSystemId(a.getBsDirectSystemId());
                auditFormEntities.add(afe);
                //关系表
                for (int iv = 0; iv < v.size(); iv++) {
                    KmsAuditMatchRelationEntity relationEntity = new KmsAuditMatchRelationEntity();
                    relationEntity.setAuditNumber(afe.getAuditNumber());
                    relationEntity.setAuditTemplateId(templateId);
                    relationEntity.setRelationId(v.get(iv).getId());
                    relationEntities.add(relationEntity);
                }
            } else {
                //关系表
                for (int iv = 0; iv < v.size(); iv++) {
                    KmsAuditMatchRelationEntity relationEntity = new KmsAuditMatchRelationEntity();
                    relationEntity.setAuditId(afe.getId());
                    relationEntity.setAuditNumber(afe.getAuditNumber());
                    relationEntity.setAuditTemplateId(templateId);
                    relationEntity.setRelationId(v.get(iv).getId());
                    relationEntities.add(relationEntity);
                }
            }
        });
    }

    /**
     * 构建稽核对象信息
     *
     * @param afe
     * @param e
     * @param templateDirectRespVo
     * @return
     */
    private void buildAuditForm(KmsAuditFormEntity afe, KmsSapInvoiceRespVo e, KmsAuditTemplateDirectRespVo templateDirectRespVo) {
        afe.setKaOrderNumber(e.getBstkd());
        afe.setDirectName(templateDirectRespVo.getDirectName());
        afe.setBsDirectSystemId(templateDirectRespVo.getBsDirectSystemId());
        afe.setBsDirectSystemCode(templateDirectRespVo.getBsDirectSystemCode());
        afe.setBsDirectSystemName(templateDirectRespVo.getBsDirectSystemName());
        afe.setAuditNumber(CodeUtil.generateCode("kms_audit_code"));
        afe.setStoreCode(KmsUtils.removeFrontZero(e.getKunnr()));
        afe.setStoreName(e.getKunnrname());
        afe.setBukrs(e.getBukrs());
        afe.setOrgCode(e.getOrgCode());
        afe.setCreateOrgCode(e.getOrgCode());
        afe.setSapPostingDate(e.getFkdat());
        afe.setSapMaterielCode(KmsUtils.removeFrontZero(e.getMatnr()));
        afe.setSapMaterielName(e.getMaktx());
        afe.setSapQuantity("0");
        afe.setIsStoreSummary(YesNoEnum.yesNoEnum.Y.getValue());
        afe.setIsAudit(YesNoEnum.yesNoEnum.no.getValue());
        afe.setAcceptanceQuantity("0");
        afe.setSapAmountNot("0");
        afe.setSapAmount("0");
        afe.setAuditStatus(KmsEnum.AuditStatus.WAIT.getValue());
        afe.setAuditResult(KmsEnum.AuditResult.WAIT.getValue());
        afe.setAcceptanceAmount("0");
        afe.setAcceptanceAmountNot("0");
        afe.setAuditTemplateId(templateDirectRespVo.getAuditTemplateId());
        afe.setDifferencePrice(templateDirectRespVo.getDifferencePrice());
        afe.setAuditRule(templateDirectRespVo.getAuditRule());
    }

    /**
     * 保存关系数据
     *
     * @param afe
     * @param relationId
     * @param templateId
     */
    private void saveMatchRelation(KmsAuditFormEntity afe, String relationId, String templateId) {
        KmsAuditMatchRelationEntity relationEntity = new KmsAuditMatchRelationEntity();
        relationEntity.setAuditId(afe.getId());
        relationEntity.setAuditNumber(afe.getAuditNumber());
        relationEntity.setAuditTemplateId(templateId);
        relationEntity.setRelationId(relationId);
        kmsAuditMatchRelationMapper.insert(relationEntity);
    }

    /**
     * 匹配数据信息
     *
     * @param respVo
     * @param templateRespVo
     * @param conditionVo
     */
    @Override
    public void matchData(KmsAuditFormRespVo respVo, KmsAuditTemplateRespVo templateRespVo) {
        //删除原匹配数据
        List<KmsAcceptanceMatchRelationEntity> relationEntities = kmsAcceptanceMatchRelationService.lambdaQuery()
                .eq(KmsAcceptanceMatchRelationEntity::getAuditId, respVo.getId()).list();
        if (!CollectionUtils.isEmpty(relationEntities)) {
            List<String> relationIds = relationEntities.stream().map(KmsAcceptanceMatchRelationEntity::getRelationId)
                    .collect(Collectors.toList());
            findMatchDataByIds(relationIds, respVo, templateRespVo);
            cancelMatchData(relationIds, respVo, templateRespVo);
        }
        //验收单数据信息
        KmsAcceptanceFormReqVo reqVo = new KmsAcceptanceFormReqVo();
        reqVo.setStoreCode(respVo.getStoreCode());
        //reqVo.setGoodsCode(respVo.getSapMaterielCode());
        //查询上架产品判断是否为星期商品
        KmsTenantryDirectProductReqVo params = new KmsTenantryDirectProductReqVo();
        params.setProductCode(respVo.getSapMaterielCode());
        params.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        params.setBsDirectSystemId(respVo.getBsDirectSystemId());
        List<KmsTenantryDirectProductRespVo> productRespVos = kmsTenantryDirectProductMapper.findListByWeek(params);
        if (CollectionUtils.isEmpty(productRespVos)) {
            reqVo.setGoodsCode(respVo.getSapMaterielCode());
        } else {
            reqVo.setKaGoodsCodeList(productRespVos.stream().map(KmsTenantryDirectProductRespVo::getKaProductCode)
                    .distinct().collect(Collectors.toList()));
        }
        reqVo.setAuditTemplateId(respVo.getAuditTemplateId());
        reqVo.setBsDirectSystemId(respVo.getBsDirectSystemId());
        //订单编号组成KMS-kaOrderNumber-storeCode
        String[] split = respVo.getKaOrderNumber().split("-");
        //防止条件缺失匹配到错误单据
        reqVo.setRelateKaOrderNumber(KmsConstant.ORDER_NUMBER);
        if (split.length == 3) {
            reqVo.setRelateKaOrderNumber(split[1]);
        }
        List<KmsAuditAcceptanceFormRespVo> acceptanceFormRespVos = kmsAcceptanceFormMapper
                .findMatchedPDS(reqVo);
        acceptanceFormRespVos.forEach(a -> {
            a.setId(a.getGoodsId());
            //验收金额处理
            //KmsUtils.acceptanceAmountHandle(a, taxRate);
        });
        respVo.setAcceptanceFormVos(acceptanceFormRespVos);
    }

    /**
     * 查询已匹配验收单
     *
     * @param respVo
     * @param templateRespVo
     */
    @Override
    public void matchDataSucc(KmsAuditFormRespVo respVo, KmsAuditTemplateRespVo templateRespVo) {
        //验收单数据信息
        KmsAcceptanceFormReqVo reqVo = new KmsAcceptanceFormReqVo();
        //查询已匹配验收单数据信息
        reqVo.setAuditTemplateId(templateRespVo.getId());
        reqVo.setAuditId(respVo.getId());
        List<KmsAuditAcceptanceFormRespVo> acceptanceFormSuccRespVos = kmsAcceptanceFormMapper
                .findMatchedSuccPDS(reqVo);
        acceptanceFormSuccRespVos.forEach(a -> {
            a.setId(a.getGoodsId());
            //验收金额处理
            //KmsUtils.acceptanceAmountHandle(a,taxRate);
        });
        respVo.setAcceptanceFormVos(acceptanceFormSuccRespVos);
    }

    /**
     * 数据绑定
     *
     * @param afVo
     * @param templateRespVo
     */
    @Override
    public void matchDataBinding(KmsAuditFormRespVo afVo, KmsAuditTemplateRespVo templateRespVo) {
        List<KmsAcceptanceMatchRelationEntity> relationEntities = Lists.newArrayList();
        //验收单号
        List<String> accIds = Lists.newArrayList();
        //数据汇总
        afVo.getAcceptanceFormVos().forEach(o -> {
            //关系表
            KmsAcceptanceMatchRelationEntity relationEntity = KmsUtils.buildAcceptanceMatchRelation(o, afVo, templateRespVo.getId());
            relationEntities.add(relationEntity);
            accIds.add(o.getHeaderId());
        });
        //保存关系
        if (!CollectionUtils.isEmpty(relationEntities)) {
            //设置状态为已匹配
            afVo.setIsAudit(YesNoEnum.yesNoEnum.yes.getValue());
            kmsAcceptanceMatchRelationService.saveBatch(relationEntities);
            //修改验收单状态为已匹配
            List<KmsAcceptanceFormEntity> acceptanceFormEntities = kmsAcceptanceFormMapper.selectBatchIds(accIds);
            acceptanceFormEntities.forEach(a -> {
                if (!KmsEnum.OrderStatus.S100.getValue().equals(a.getOrderStatus())) {
                    a.setOrderStatus(KmsEnum.OrderStatus.S600.getValue());
                    a.setOrderStatusMsg(KmsEnum.OrderStatus.S600.getDescription());
                }
                kmsAcceptanceFormMapper.updateById(a);
            });
            kmsAcceptanceStatusRecordService.insert(acceptanceFormEntities);
        }
    }

    /**
     * 手动匹配/取消根据Ids查询验收数据
     *
     * @param relationIdIds
     * @param respVo
     * @param templateRespVo
     */
    @Override
    public void findMatchDataByIds(List<String> relationIdIds, KmsAuditFormRespVo respVo, KmsAuditTemplateRespVo templateRespVo) {
        //验收单数据信息
        KmsAcceptanceFormReqVo reqVo = new KmsAcceptanceFormReqVo();
        reqVo.setIds(relationIdIds);
        List<KmsAuditAcceptanceFormRespVo> acceptanceFormRespVos = kmsAcceptanceFormMapper
                .findMatchedPDS(reqVo);
        respVo.setAcceptanceFormVos(acceptanceFormRespVos);
    }

    /**
     * 取消数据绑定
     *
     * @param relationIdIds
     * @param afVo
     * @param templateRespVo
     */
    @Override
    public void cancelMatchData(List<String> relationIdIds, KmsAuditFormRespVo afVo, KmsAuditTemplateRespVo templateRespVo) {
        //验收单号
        List<String> accIds = Lists.newArrayList();
        afVo.getAcceptanceFormVos().forEach(o -> {
            accIds.add(o.getHeaderId());
        });
        //根据稽核ID，模版ID，关系数据ID删除稽核关系数据
        kmsAcceptanceMatchRelationService.lambdaUpdate()
                .eq(KmsAcceptanceMatchRelationEntity::getAuditId, afVo.getId())
                .eq(KmsAcceptanceMatchRelationEntity::getAuditTemplateId, templateRespVo.getId())
                .in(KmsAcceptanceMatchRelationEntity::getRelationId, relationIdIds).remove();
        //查询验收单是否还存在匹配记录
        List<KmsAcceptanceMatchRelationEntity> entities = CollectionUtils.isEmpty(accIds) ? Lists.newArrayList() : kmsAcceptanceMatchRelationService.lambdaQuery()
                .in(KmsAcceptanceMatchRelationEntity::getHeaderId, accIds).list();
        Map<String, List<KmsAcceptanceMatchRelationEntity>> listMap = entities.stream()
                .collect(Collectors.groupingBy(KmsAcceptanceMatchRelationEntity::getHeaderId));
        //获取不存在匹配记录单验收单数据信息
        List<String> notRelationIds = Lists.newArrayList();
        accIds.forEach(o -> {
            List<KmsAcceptanceMatchRelationEntity> relationEntities = listMap.get(o);
            if (CollectionUtils.isEmpty(relationEntities)) {
                notRelationIds.add(o);
            }
        });
        if (!CollectionUtils.isEmpty(notRelationIds)) {
            //修改验收单状态为待处理
            List<KmsAcceptanceFormEntity> acceptanceFormEntities = kmsAcceptanceFormMapper.selectBatchIds(accIds);
            acceptanceFormEntities.forEach(a -> {
                if (KmsEnum.OrderStatus.S400.getDescription().equals(a.getOrderStatusMsg())
                        || KmsEnum.OrderStatus.S600.getDescription().equals(a.getOrderStatusMsg())) {
                    a.setOrderStatus(KmsEnum.OrderStatus.S400.getValue());
                    a.setOrderStatusMsg(KmsEnum.OrderStatus.S400.getDescription());
                } else {
                    a.setOrderStatus(KmsEnum.OrderStatus.S100.getValue());
                }
                kmsAcceptanceFormMapper.updateById(a);
            });
            kmsAcceptanceStatusRecordService.insert(acceptanceFormEntities);
            afVo.setIsAudit(YesNoEnum.yesNoEnum.no.getValue());
        }
    }

    /**
     * 查询未匹配验收单
     *
     * @param page
     * @param reqVo
     * @return
     */
    @Override
    public List<KmsAuditAcceptanceFormRespVo> notmatchedAcceptanceFormList(Page<KmsAuditAcceptanceFormRespVo> page, KmsAcceptanceFormReqVo reqVo) {
        return kmsAcceptanceFormMapper.findNotMatchedPDS(page, reqVo);
    }

    /**
     * 手动匹配查询待匹配验收单数据列表
     *
     * @param respVo
     * @param templateRespVo
     * @return
     */
    @Override
    public PageResult<KmsAuditAcceptanceFormRespVo> waitMatchedAcc(KmsAuditFormReqVo reqVo, KmsAuditFormRespVo respVo, KmsAuditTemplateRespVo templateRespVo) {
        //验收单数据信息
        KmsAcceptanceFormReqVo queryVo = new KmsAcceptanceFormReqVo();
        queryVo.setStoreCode(respVo.getStoreCode());
        //queryVo.setGoodsCode(respVo.getSapMaterielCode());
        queryVo.setBsDirectSystemId(respVo.getBsDirectSystemId());

        /*人工手动匹配查找验收单取消单号条件
        //订单编号组成KMS-kaOrderNumber-storeCode
        String[] split = respVo.getKaOrderNumber().split("-");
        //防止条件缺失匹配到错误单据
        queryVo.setRelateKaOrderNumber(KmsConstant.ORDER_NUMBER);
        if (split.length == 3) {
            queryVo.setRelateKaOrderNumber(split[1]);
        } else {
            queryVo.setRelateKaOrderNumber("NULL");
        }*/

        //查询上架产品判断是否为星期商品
        KmsTenantryDirectProductReqVo params = new KmsTenantryDirectProductReqVo();
        params.setProductCode(respVo.getSapMaterielCode());
        params.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        params.setBsDirectSystemId(respVo.getBsDirectSystemId());
        List<KmsTenantryDirectProductRespVo> productRespVos = kmsTenantryDirectProductMapper.findListByWeek(params);
        if (CollectionUtils.isEmpty(productRespVos)) {
            queryVo.setGoodsCode(respVo.getSapMaterielCode());
        } else {
            queryVo.setKaGoodsCodeList(productRespVos.stream().map(KmsTenantryDirectProductRespVo::getKaProductCode)
                    .distinct().collect(Collectors.toList()));
        }
        //查询已匹配验收单数据信息
        queryVo.setAuditTemplateId(templateRespVo.getId());
        queryVo.setAuditId(respVo.getId());
        //手动匹配查询待匹配验收单数据列表
        Page<KmsAuditAcceptanceFormRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        queryVo.setAcceptanceDateStart(reqVo.getAcceptanceDateStart());
        queryVo.setAcceptanceDateEnd(reqVo.getAcceptanceDateEnd());
        String kaOrderNumber = respVo.getKaOrderNumber();
        queryVo.setRelateKaOrderNumber(KmsConstant.ORDER_NUMBER);
        if(!StringUtils.isEmpty(kaOrderNumber)){
            String[] split = kaOrderNumber.split("-");
            if (split.length == 3) {
                queryVo.setRelateKaOrderNumber(split[1]);
            }
        }
        queryVo.setOrderNumber(reqVo.getOrderNumber());
        List<KmsAuditAcceptanceFormRespVo> list = kmsAcceptanceFormMapper.findMatchedPDS(page, queryVo);
        return PageResult.<KmsAuditAcceptanceFormRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询已匹配验收单数据列表
     *
     * @param reqVo
     * @param respVo
     * @param templateRespVo
     * @return
     */
    @Override
    public PageResult<KmsAuditAcceptanceFormRespVo> matchedAcc(KmsAuditFormReqVo reqVo, KmsAuditFormRespVo respVo, KmsAuditTemplateRespVo templateRespVo) {
        //验收单数据信息
        KmsAcceptanceFormReqVo queryVo = new KmsAcceptanceFormReqVo();
        //查询已匹配验收单数据信息
        queryVo.setAuditTemplateId(templateRespVo.getId());
        queryVo.setAuditId(respVo.getId());
        Page<KmsAuditAcceptanceFormRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        queryVo.setAcceptanceDateStart(reqVo.getAcceptanceDateStart());
        queryVo.setAcceptanceDateEnd(reqVo.getAcceptanceDateEnd());
        queryVo.setOrderNumber(reqVo.getOrderNumber());
        List<KmsAuditAcceptanceFormRespVo> list = kmsAcceptanceFormMapper.findMatchedSuccPDS(page, queryVo);
        return PageResult.<KmsAuditAcceptanceFormRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    @Override
    public void delayedReceiptAcc(KmsAuditFormRespVo o, KmsAuditTemplateRespVo auditTemplateRespVo) {

    }
}