package com.biz.crm.finance.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.finance.model.KmsAuditMatchRelationEntity;
import com.biz.crm.nebular.kms.finance.req.KmsAuditFormReqVo;
import com.biz.crm.nebular.kms.finance.req.KmsAuditMatchRelationReqVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditMatchRelationRespVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 稽核匹配关系表
 * 
 * @author Gavin
 * @date 2021-05-27 15:14:19
 */
public interface KmsAuditMatchRelationMapper extends BaseMapper<KmsAuditMatchRelationEntity> {
    /**
     * 列表
     * @param page
     * @param kmsAuditMatchRelationReqVo
     * @return
     */
    List<KmsAuditMatchRelationRespVo> findList(Page<KmsAuditMatchRelationRespVo> page, @Param("vo") KmsAuditMatchRelationReqVo kmsAuditMatchRelationReqVo);

    /**
     * 查询是否已汇总
     * @param relationId
     * @param templateId
     * @return
     */
    KmsAuditMatchRelationRespVo findByRelationIdAndTemplateId(@Param("relationId") String relationId, @Param("templateId") String templateId);

    /**
     * sap发票号查询关系
     * @param reqVo
     * @return
     */
    List<KmsAuditMatchRelationRespVo> findMatchList(@Param("vo") KmsAuditFormReqVo reqVo);
}
