package com.biz.crm.finance.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.finance.model.KmsAuditTemplateEntity;
import com.biz.crm.nebular.kms.finance.req.KmsAuditTemplateReqVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditTemplateRespVo;

import java.util.List;

/**
 * 稽核模板接口
 *
 * @author Gavin
 * @date 2021-05-25 17:56:09
 */
public interface IKmsAuditTemplateService extends IService<KmsAuditTemplateEntity> {

    /**
     * 列表
     * @param kmsAuditTemplateReqVo
     * @return PageResult<KmsAuditTemplateRespVo>
     */
    PageResult<KmsAuditTemplateRespVo> findList(KmsAuditTemplateReqVo kmsAuditTemplateReqVo);

    /**
     * 查询
     * @param kmsAuditTemplateReqVo
     * @return KmsAuditTemplateRespVo
     */
    KmsAuditTemplateRespVo query(KmsAuditTemplateReqVo kmsAuditTemplateReqVo);

    /**
     * 新增
     * @param kmsAuditTemplateReqVo
     * @return
     */
    void save(KmsAuditTemplateReqVo kmsAuditTemplateReqVo);

    /**
     * 更新
     * @param kmsAuditTemplateReqVo
     * @return
     */
    void update(KmsAuditTemplateReqVo kmsAuditTemplateReqVo);

    /**
     * 删除
     * @param kmsAuditTemplateReqVo
     * @return
     */
    void deleteBatch(KmsAuditTemplateReqVo kmsAuditTemplateReqVo);

    /**
     * 启用
     * @param kmsAuditTemplateReqVo
     * @return
     */
    void enableBatch(KmsAuditTemplateReqVo kmsAuditTemplateReqVo);

    /**
     * 禁用
     * @param kmsAuditTemplateReqVo
     * @return
     */
    void disableBatch(KmsAuditTemplateReqVo kmsAuditTemplateReqVo);

    /**
     * 查询所有有效稽核模版
     * @param templateReqVo
     * @return
     */
    List<KmsAuditTemplateRespVo> findAll(KmsAuditTemplateReqVo templateReqVo);
}

