package com.biz.crm.grabrule.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.biz.crm.constant.KmsParmConstant;
import com.biz.crm.eunm.kms.KmsEnum;
import com.biz.crm.grabrule.mapper.KmsLoggerDataProcessMapper;
import com.biz.crm.grabrule.model.KmsLoggerDataProcessEntity;
import com.biz.crm.nebular.kms.grabrule.req.KmsLoggerDataProcessReqVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.List;

/**
 * @Project crm
 * @PackageName com.biz.crm.grabrule.helper
 * @ClassName KmsLoggerDataProcessHelper
 * @Author Gavin
 * @Date 2021/5/11 下午1:40
 * @Description 抓单日志助手
 */
@Slf4j
@Component
public class KmsLoggerDataProcessHelper {

    @Resource
    private KmsLoggerDataProcessMapper kmsLoggerDataProcessMapper;

    /**
     * 构建抓单日志实体
     * @param reqVo
     * @return
     */
    public KmsLoggerDataProcessEntity buildEntity(KmsLoggerDataProcessReqVo reqVo) {
        //抓单信息
        String msg = "";
        //解析日志
        String resultStr = reqVo.getResultStr();
        JSONObject result = JSONObject.parseObject(resultStr);
        //请求参数
        JSONObject reqObject = result.getJSONObject(KmsParmConstant.PARAM_REQ_OBJECT);
        //抓单结果
        JSONObject respObject = result.getJSONObject(KmsParmConstant.PARAM_RESP_OBJECT);

        //请求参数
        JSONObject reqParm = reqObject.getJSONObject(KmsParmConstant.GRPC_REQ_BODY).getJSONObject(KmsParmConstant.GRPC_REQ_EXTEND_ARGS).getJSONObject(KmsParmConstant.GRPC_REQ_REQ_PARAM);
        //扩展参数
        JSONObject extendParm = reqObject.getJSONObject(KmsParmConstant.GRPC_REQ_BODY).getJSONObject(KmsParmConstant.GRPC_REQ_EXTEND_ARGS).getJSONObject(KmsParmConstant.GRPC_REQ_EXTEND_PARAM);

        String doc = reqParm.getString(KmsParmConstant.DOC);
        String kaName = reqParm.getString(KmsParmConstant.KA_NAME);
        String style = extendParm.getString(KmsParmConstant.STYLE);
        String loginAcc = reqParm.getString(KmsParmConstant.USER_NAME);
        String ruleName = extendParm.getString(KmsParmConstant.RULE_NAME);
        String tenantryId = extendParm.getString(KmsParmConstant.TENANTRY_ID);
        String nickName = extendParm.getString(KmsParmConstant.NICK_NAME);
        String trackId = extendParm.getString(KmsParmConstant.TRACK_ID);
        String rawDataId = extendParm.getString(KmsParmConstant.RESP_DATA_ID);
        String bsDirectSystemId = extendParm.getString(KmsParmConstant.DIRECT_SYSTEM_ID);

        //状态
        String grabState = KmsEnum.GrabState.SUCCEED.getValue();
        // 1、没有返回正常的抓单结果结构（AI问题）
        if (StringUtils.isEmpty(respObject)) {
            msg = "没有返回正常的抓单结果结构（AI问题）";
            grabState = KmsEnum.GrabState.FAILED.getValue();
        }

        // 2、返回结构中没有"result"（AI问题）
        if (!respObject.containsKey(KmsParmConstant.GRPC_RESP_RESULT)) {
            msg = "返回结构中没有result（AI问题）," + respObject.getString(KmsParmConstant.GRPC_RESP_ERROR_MSG);
            grabState = KmsEnum.GrabState.FAILED.getValue();
        }else {
            // 2.1 获取公共属性
            JSONObject resultObject = respObject.getJSONObject(KmsParmConstant.GRPC_RESP_RESULT);
            Integer login = resultObject.getInteger(KmsParmConstant.GRPC_RESP_LOGIN);
            JSONArray errors = resultObject.getJSONArray(KmsParmConstant.GRPC_RESP_ERRORS);
            JSONObject info = resultObject.getJSONObject(KmsParmConstant.GRPC_RESP_INFO);
            Integer totalNum = info.getInteger(KmsParmConstant.GRPC_RESP_TOTAL_NUM);
            Integer successNum = info.getInteger(KmsParmConstant.GRPC_RESP_SUCCEED);
            Integer dittoNum = info.getInteger(KmsParmConstant.GRPC_RESP_DITTO);

            // 3、登录失败（商超网站问题）
            if (login == 0) {
                msg = "登录失败,账号或密码错误";
                grabState = KmsEnum.GrabState.FAILED.getValue();
            }
            // 3.1 获取公共属性
            JSONArray form = resultObject.getJSONArray(KmsParmConstant.GRPC_RESP_FORM);
            // 4、到这里，登录已经成功（数据返回空且无报错信息）
            if (CollectionUtils.isEmpty(form) && CollectionUtils.isEmpty(errors)) {
                JSONArray array = new JSONArray();
                if (dittoNum == 0) {
                    // 4.1 当次商超抓单没有抓取数据（可能原本就没有数据，正常情况）
                    msg = "KA网站在当前条件下没有单据";
                } else {
                    // 4.2 当次商超抓单有数据，但是全部重复被去重（程序去重不是报错，正常情况）
                    msg = "KA网站当前查询条件下单据全部重复";
                }
            }
            // 5、数据返回空且有报错信息（AI的问题）
            if (CollectionUtils.isEmpty(form) && !CollectionUtils.isEmpty(errors)) {
                msg = errors.toJSONString();
                grabState = KmsEnum.GrabState.FAILED.getValue();
            }
            //最终结果
            if(StringUtils.isEmpty(msg)){
                msg = "当前查询条件下成功抓取" + successNum + "条数据，去掉重复数据" + dittoNum + "条";
            }
        }

        //根据rawDataId判断是否存在
        LambdaQueryWrapper<KmsLoggerDataProcessEntity> queryWrapper = new LambdaQueryWrapper<KmsLoggerDataProcessEntity>()
                .eq(KmsLoggerDataProcessEntity::getRawDataId,rawDataId);
        List<KmsLoggerDataProcessEntity> processEntities = kmsLoggerDataProcessMapper.selectList(queryWrapper);
        KmsLoggerDataProcessEntity entity = processEntities.stream().findFirst().orElse(null);
        if(ObjectUtils.isEmpty(entity)){
            entity = new KmsLoggerDataProcessEntity();
            entity.setOrderTypeName(doc);
            entity.setBsDirectSystemId(bsDirectSystemId);
            entity.setGrabState(grabState);
            entity.setKaName(kaName);
            entity.setLoginAcc(loginAcc);
            entity.setNickName(nickName);
            entity.setRawDataId(rawDataId);
            entity.setRuleName(ruleName);
            entity.setStyle(style);
            entity.setTenantryId(tenantryId);
            entity.setGrabMessage(msg);
        }else{
            entity.setGrabMessage(msg);
            //判断状态是否相同
            if(!entity.getGrabState().equals(grabState)){
                entity.setGrabState(grabState);
            }
        }
        return entity;
    }
}