package com.biz.crm.grabrule.helper;

import java.time.Instant;
import java.time.LocalDateTime;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

import javax.annotation.Resource;

import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.confadmin.service.IKmsAdminService;
import com.biz.crm.config.KmsConfig;
import com.biz.crm.constant.KmsParmConstant;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.kms.KmsAdminEnum;
import com.biz.crm.eunm.kms.KmsEnum;
import com.biz.crm.grabrule.mapper.KmsGrabRuleParamMapper;
import com.biz.crm.grabrule.mapper.KmsGrabRuleStoreMapper;
import com.biz.crm.grabrule.model.KmsDataAuthEntity;
import com.biz.crm.grabrule.model.KmsGrabRuleParamEntity;
import com.biz.crm.grabrule.model.KmsLoggerDataProcessEntity;
import com.biz.crm.grabrule.model.KmsRequestEntity;
import com.biz.crm.nebular.kms.confadmin.base.BaseClassifyConstants;
import com.biz.crm.nebular.kms.confadmin.base.BaseDateFlagConstants;
import com.biz.crm.nebular.kms.confadmin.base.ComomStatus;
import com.biz.crm.nebular.kms.confadmin.req.BsGrabInterfaceParamReqVo;
import com.biz.crm.nebular.kms.confadmin.resp.BsGrabInterfaceParamRespVo;
import com.biz.crm.nebular.kms.confadmin.resp.BsGrabInterfaceSubParamOptionRespVo;
import com.biz.crm.nebular.kms.grabrule.req.KmsGrabRuleParamReqVo;
import com.biz.crm.nebular.kms.grabrule.req.KmsGrabRuleReqVo;
import com.biz.crm.nebular.kms.grabrule.resp.KmsGrabRuleParamRespVo;
import com.biz.crm.nebular.kms.grabrule.resp.KmsGrabRuleRespVo;
import com.biz.crm.nebular.kms.grabrule.resp.KmsGrabRuleStoreRespVo;
import com.biz.crm.supermarket.model.KmsTenantryDirectCustomerOrgEntity;
import com.biz.crm.supermarket.service.IKmsTenantryDirectCustomerOrgService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.google.common.collect.Lists;

import lombok.extern.slf4j.Slf4j;

/**
 * @Project crm
 * @PackageName com.biz.crm.grabrule.helper
 * @ClassName KmsRequestHelper
 * @Author Gavin
 * @Date 2021/5/10 下午2:20
 * @Description 抓单信息封装助手
 */
@Slf4j
@Component
public class KmsRequestHelper {

    @Resource
    private KmsGrabRuleParamMapper kmsGrabRuleParamMapper;

    @Resource
    private KmsGrabRuleStoreMapper kmsGrabRuleStoreMapper;

    @Resource
    private IKmsAdminService kmsAdminService;

    @Resource
    private IKmsTenantryDirectCustomerOrgService kmsTenantryDirectCustomerOrgService;

    @Resource
    private KmsConfig kmsConfig;

    /**
     * 构建抓单参数
     * @param grabRuleEntityId 规则ID
     * @return
     */
    public JSONObject buildReqPams(String grabRuleEntityId) {
        JSONObject reqParm = new JSONObject();

        //抓单请求参数
        LambdaQueryWrapper<KmsGrabRuleParamEntity> paramEntityWrapper = new LambdaQueryWrapper<KmsGrabRuleParamEntity>()
                .eq(KmsGrabRuleParamEntity::getGrabRuleId,grabRuleEntityId);
        List<KmsGrabRuleParamEntity> ruleParamEntities = kmsGrabRuleParamMapper.selectList(paramEntityWrapper);

        if (!CollectionUtils.isEmpty(ruleParamEntities)) {
            ruleParamEntities.forEach(o -> {
                if(!StringUtils.isEmpty(o.getStartTimeFieldEn()) || !StringUtils.isEmpty(o.getEndTimeFieldEn())){
                    if(!StringUtils.isEmpty(o.getStartTimeFieldEn())) {
                        //开始时间
                        Calendar cl = Calendar.getInstance();
                        cl.add(Calendar.DAY_OF_MONTH,Integer.parseInt(o.getFieldValue()) * -1);
                        Date todayStartTime = DateUtil.getTodayStartTime(cl.getTime());
                        reqParm.put(o.getStartTimeFieldEn(), String.valueOf(todayStartTime.getTime()));
                    }
                    if(!StringUtils.isEmpty(o.getEndTimeFieldEn())) {
                        //结束时间
                        reqParm.put(o.getEndTimeFieldEn(),String.valueOf(DateUtil.getTodayEndTime(new Date()).getTime()));
                    }
                }else{
                    reqParm.put(o.getFieldEn(),StringUtils.isEmpty(o.getFieldValue()) ? "" : o.getFieldValue());
                }
            });
        }
        return reqParm;
    }

    /**
     * 构建抓单门店
     * @param reqParm
     * @param grabRuleEntityId 规则ID
     * @param isAllStore 是否全部门店
     */
    public void buildReqPamStore(JSONObject reqParm,String grabRuleEntityId,String isAllStore) {
        List<Map<String, String>> storeList = new ArrayList<>();
        if (YesNoEnum.yesNoEnum.NO.getValue().equals(isAllStore)) {
            reqParm.put(KmsParmConstant.KMS_ALL_STORE, "false");
            List<KmsGrabRuleStoreRespVo> directStoreRespVos = kmsGrabRuleStoreMapper.findByGrabRuleId(grabRuleEntityId);
            // 特定门店
            directStoreRespVos.forEach(x -> {
                Map<String, String> storeMap = new HashMap<>(2);
                storeMap.put(KmsParmConstant.STORE_CODE, x.getStoreCode());
                storeMap.put(KmsParmConstant.STORE_NAME, x.getStoreName());
                storeList.add(storeMap);
            });
        } else {
            reqParm.put(KmsParmConstant.KMS_ALL_STORE, "true");
            // 全部门店（抓单意义上的全选）
            Map<String, String> storeMap = new HashMap<>(2);
            storeMap.put(KmsParmConstant.STORE_CODE, "");
            storeMap.put(KmsParmConstant.STORE_NAME, "");
            storeList.add(storeMap);
        }
        reqParm.put(KmsParmConstant.SOLD_TO_PARTY, storeList);
    }

    /**
     * 公共参数
     * @param reqParm
     * @param grabRuleRespVo
     */
    public void buildCommonReqPams(JSONObject reqParm, KmsGrabRuleRespVo grabRuleRespVo) {
        reqParm.put(KmsParmConstant.KA_NAME, grabRuleRespVo.getBsDirectSystemName());
        reqParm.put(KmsParmConstant.DOC, KmsAdminEnum.OrderType.GETMAP.get(grabRuleRespVo.getOrderType()));
        reqParm.put(KmsParmConstant.USER_NAME, grabRuleRespVo.getLoginAcc());
        reqParm.put(KmsParmConstant.PASS_WORD, grabRuleRespVo.getLoginPass());
        reqParm.put(KmsParmConstant.KMS_PATH_TYPE, kmsConfig.getKaFlag());
        reqParm.put(KmsParmConstant.KMS_IP, "");
        reqParm.put(KmsParmConstant.PRINCIPAL_ID, grabRuleRespVo.getCreateName());
        // 'force'：'0' 表示会md5去重(自动抓单强制覆盖为md5去重)
        reqParm.put(KmsParmConstant.FORCE, "0");
        // 增加租户ID，AI为了MD5去重
        reqParm.put(KmsParmConstant.TENANTRY_ID, kmsConfig.getTenantryId());
    }

    /**
     * 构建扩展字段
     * @param grabRuleRespVo
     * @param trackId
     * @param autoType
     * @return
     */
    public JSONObject buildExtendParms(KmsGrabRuleRespVo grabRuleRespVo,String trackId,KmsAdminEnum.AutoType autoType) {
        JSONObject extendParm = new JSONObject();
        //租户ID
        extendParm.put(KmsParmConstant.TENANTRY_ID, kmsConfig.getTenantryId());
        extendParm.put(KmsParmConstant.RULE_NAME, grabRuleRespVo.getRuleName());
        //直营体系ID 这里取编码
        extendParm.put(KmsParmConstant.DIRECT_SYSTEM_ID, grabRuleRespVo.getBsDirectSystemId());
        //单据类型ID 这里取编码
        extendParm.put(KmsParmConstant.BS_INVOICE_ID, grabRuleRespVo.getOrderTypeId());
        extendParm.put(KmsParmConstant.KA_FLAG, kmsConfig.getKaFlag());
        extendParm.put(KmsParmConstant.TRACK_ID, trackId);
        extendParm.put(KmsParmConstant.STYLE, autoType.getDescription());
        extendParm.put(KmsParmConstant.NICK_NAME, grabRuleRespVo.getNickName());
        extendParm.put(KmsParmConstant.RESP_DATA_ID, grabRuleRespVo.getRawDataId());
        return extendParm;
    }

    /**
     * 最终参数构成
     * @param reqParm
     * @param extendParm
     * @return
     */
    public JSONObject buildRequest(JSONObject reqParm, JSONObject extendParm) {

        JSONObject inputFile = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        jsonArray.add("");
        inputFile.put("file_names", jsonArray);
        inputFile.put("file_type", "url");

        JSONObject extendArgs = new JSONObject();
        extendArgs.put("req_parm", reqParm);
        extendArgs.put("extend_parm", extendParm);

        JSONObject body = new JSONObject();
        body.put("extend_args", extendArgs);
        body.put("input_file", inputFile);

        JSONObject request = new JSONObject();
        request.put("app_id", "ka_grab_order");
        request.put("body", body);
        return  request;
    }

    /**
     * 构建自动抓单实体
     * @param grabRuleRespVo
     * @param request
     * @param autoType
     * @return
     */
    public KmsRequestEntity buildRequestEntity(KmsGrabRuleRespVo grabRuleRespVo, JSONObject request, KmsAdminEnum.AutoType autoType) {
        KmsRequestEntity entity = new KmsRequestEntity();
        entity.setAuto(autoType.getValue());
        entity.setFile(KmsAdminEnum.FileType.DATA.getValue());
        entity.setTime(LocalDateTime.now());
        entity.setResponse("");
        //关联字段(用于关联单据和文件)
        entity.setUuid(UUID.randomUUID().toString().replaceAll("-", ""));
        //抓单据默认为0，文件默认为-1
        entity.setFail(0);
        entity.setMethod(grabRuleRespVo.getOrderDownloadWay());
        entity.setRequest(request.toJSONString());
        return entity;
    }

    /**
     * 构建数据权限
     * @param entity
     * @param grabRuleRespVo
     * @param respDataId
     * @return
     */
    public KmsDataAuthEntity buildAuthEntity(KmsGrabRuleRespVo grabRuleRespVo) {
        KmsDataAuthEntity authEntity = CrmBeanUtil.copy(grabRuleRespVo,KmsDataAuthEntity.class);
        authEntity.setBsDirectSystemId(grabRuleRespVo.getBsDirectSystemId());
        authEntity.setRespDataId(grabRuleRespVo.getRawDataId());
        authEntity.setId(null);
        return authEntity;
    }

    /**
     * 构建抓单日志
     * @param grabRuleRespVo
     * @param auto
     * @return
     */
    public KmsLoggerDataProcessEntity buildLogger(KmsGrabRuleRespVo grabRuleRespVo, KmsAdminEnum.AutoType auto) {
        KmsLoggerDataProcessEntity loggerEntity = new KmsLoggerDataProcessEntity();
        loggerEntity.setOrderTypeName(KmsAdminEnum.OrderType.GETMAP.get(grabRuleRespVo.getOrderType()));
        loggerEntity.setBsDirectSystemId(grabRuleRespVo.getBsDirectSystemId());
        loggerEntity.setKaName(grabRuleRespVo.getBsDirectSystemName());
        loggerEntity.setLoginAcc(grabRuleRespVo.getLoginAcc());
        loggerEntity.setNickName(grabRuleRespVo.getNickName());
        loggerEntity.setRawDataId(grabRuleRespVo.getRawDataId());
        loggerEntity.setRuleName(grabRuleRespVo.getRuleName());
        loggerEntity.setStyle(auto.getDescription());
        loggerEntity.setTenantryId(kmsConfig.getTenantryId());
        loggerEntity.setGrabState(KmsEnum.GrabState.GRAB_ING.getValue());
        return loggerEntity;
    }

    /**
     * 手动抓单处理抓单参数
     * @param reqVo
     * @return
     */
    public JSONObject buildManualGrabReqPams(KmsGrabRuleReqVo reqVo) {
        List<KmsGrabRuleParamRespVo> ruleParamEntities = Lists.newArrayList();
        List<KmsGrabRuleParamReqVo> ruleParamReqVos = reqVo.getRuleParamList();
        if(CollectionUtil.listNotEmptyNotSizeZero(ruleParamReqVos)) {
            //查询参数信息
            KmsTenantryDirectCustomerOrgEntity directCustomerOrgEntity = kmsTenantryDirectCustomerOrgService.lambdaQuery()
                    .eq(KmsTenantryDirectCustomerOrgEntity::getId, reqVo.getBsDirectSystemId()).one();
            BsGrabInterfaceParamReqVo params = new BsGrabInterfaceParamReqVo();
            params.setDirectId(directCustomerOrgEntity.getDirectId());
            params.setOrderType(reqVo.getOrderType());
            List<BsGrabInterfaceParamRespVo> grabOrderParams = kmsAdminService.findGrabOrderParams(params);
            Map<String, BsGrabInterfaceParamRespVo> paramRespVoMap = grabOrderParams.stream()
                    .collect(Collectors.toMap(BsGrabInterfaceParamRespVo::getFieldId, Function.identity()));
            //参数数量必须相同
            if(grabOrderParams.size() != ruleParamReqVos.size()){
                throw new BusinessException("参数数量不符，请重新获取参数信息!");
            }
            ruleParamEntities = ruleParamReqVos.stream().map(o -> {
                BsGrabInterfaceParamRespVo paramRespVo = paramRespVoMap.get(o.getFieldId());
                //判断是否为必填
                if (ComomStatus.YES.equals(paramRespVo.getIsRequired()) && com.biz.crm.util.StringUtils.isEmpty(o.getFieldValue())) {
                    throw new BusinessException("参数[" + o.getFieldCn() + "]为必填字段!");
                }
                o.setGrabRuleId(reqVo.getId());
                //日期控件特殊处理
                if (BaseClassifyConstants.FieldClassify.DATE.getValue().equals(o.getFieldClassify())
                        || BaseClassifyConstants.FieldClassify.DATERANGE.getValue().equals(o.getFieldClassify())) {
                    this.dateHandle(o);
                }
                return CrmBeanUtil.copy(o, KmsGrabRuleParamRespVo.class);
            }).collect(Collectors.toList());
        }else{
            throw new BusinessException("抓单参数信息不能为空！");
        }
        JSONObject reqParm = new JSONObject();
        if (!CollectionUtils.isEmpty(ruleParamEntities)) {
            ruleParamEntities.forEach(o -> {
                if(!StringUtils.isEmpty(o.getStartTimeFieldEn()) || !StringUtils.isEmpty(o.getEndTimeFieldEn())){
                    if(!StringUtils.isEmpty(o.getStartTimeFieldEn())) {
                        if(StringUtils.isEmpty(o.getStartTime())) {
                            //开始时间
                            if (!StringUtils.isEmpty(o.getFieldValue())) {
                                Calendar cl = Calendar.getInstance();
                                cl.add(Calendar.DAY_OF_MONTH, Integer.parseInt(o.getFieldValue()) * -1);
                                Date todayStartTime = DateUtil.getTodayStartTime(cl.getTime());
                                reqParm.put(o.getStartTimeFieldEn(), String.valueOf(todayStartTime.getTime()));
                            } else {
                                reqParm.put(o.getStartTimeFieldEn(), "");
                            }
                        }else{
                            Date date = DateUtil.getDate(Long.parseLong(o.getStartTime()));
                            String startTime = String.valueOf(DateUtil.getTodayStartTime(date).getTime());
                            reqParm.put(o.getStartTimeFieldEn(), startTime);
                        }
                    }
                    if(!StringUtils.isEmpty(o.getEndTimeFieldEn())) {
                        if(StringUtils.isEmpty(o.getEndTime())){
                            //结束时间
                            if(!StringUtils.isEmpty(o.getFieldValue())){
                                reqParm.put(o.getEndTimeFieldEn(),String.valueOf(DateUtil.getTodayEndTime(new Date()).getTime()));
                            }else{
                                reqParm.put(o.getEndTimeFieldEn(), "");
                            }
                        }else{
                            Date date = DateUtil.getDate(Long.parseLong(o.getEndTime()));
                            String endTime = String.valueOf(DateUtil.getTodayEndTime(date).getTime());
                            reqParm.put(o.getEndTimeFieldEn(), endTime);
                        }
                    }
                }else{
                    reqParm.put(o.getFieldEn(),StringUtils.isEmpty(o.getFieldValue()) ? "" : o.getFieldValue());
                }
            });
        }
        return reqParm;
    }

    /**
     * 日期控件单独处理
     * @param o
     */
    protected void dateHandle(KmsGrabRuleParamReqVo field) {
        List<BsGrabInterfaceSubParamOptionRespVo> subOptions = field.getSubOptions();
        if (CollectionUtil.listNotEmptyNotSizeZero(subOptions)) {
            Instant now = Instant.now();
            subOptions.forEach(y -> {
                if (BaseDateFlagConstants.DateFlagClassify.START.getValue().equals(y.getDateFlagClassify())) {
                    field.setStartTimeFieldEn(y.getOptionValue());
                    field.setStartTime(y.getSetValue());
                } else if (BaseDateFlagConstants.DateFlagClassify.END.getValue().equals(y.getDateFlagClassify())) {
                    field.setEndTimeFieldEn(y.getOptionValue());
                    field.setEndTime(y.getSetValue());
                }
            });
        }else{
            throw new BusinessException("subOptions子参数信息不能为空");
        }
    }
}