package com.biz.crm.grabrule.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.grabrule.model.KmsLoggerDataProcessEntity;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.kms.grabrule.req.KmsLoggerDataProcessReqVo;
import com.biz.crm.nebular.kms.grabrule.resp.KmsLoggerDataProcessRespVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 单据抓取日志
 * 
 * @author Gavin
 * @date 2021-05-11 11:32:23
 */
public interface KmsLoggerDataProcessMapper extends BaseMapper<KmsLoggerDataProcessEntity> {
    /**
     * 列表
     * @param page
     * @param kmsLoggerDataProcessReqVo
     * @return
     */
    @SqlPrivilege(posCode = "t.create_pos_code",orgCode = "t.create_org_code")
    List<KmsLoggerDataProcessRespVo> findList(Page<KmsLoggerDataProcessRespVo> page, @Param("vo") KmsLoggerDataProcessReqVo kmsLoggerDataProcessReqVo);

}
