package com.biz.crm.grabrule.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.grabrule.mapper.KmsGrabRuleParamMapper;
import com.biz.crm.grabrule.model.KmsGrabRuleParamEntity;
import com.biz.crm.grabrule.service.IKmsGrabRuleParamService;
import com.biz.crm.nebular.kms.grabrule.req.KmsGrabRuleParamReqVo;
import com.biz.crm.nebular.kms.grabrule.resp.KmsGrabRuleParamRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 抓单规则参数配置表接口实现
 *
 * @author Gavin
 * @date 2021-04-16 17:00:42
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="KmsGrabRuleParamServiceExpandImpl")
public class KmsGrabRuleParamServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<KmsGrabRuleParamMapper, KmsGrabRuleParamEntity> implements IKmsGrabRuleParamService {

    @Resource
    private KmsGrabRuleParamMapper kmsGrabRuleParamMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<KmsGrabRuleParamRespVo> findList(KmsGrabRuleParamReqVo reqVo){
        Page<KmsGrabRuleParamRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<KmsGrabRuleParamRespVo> list = kmsGrabRuleParamMapper.findList(page, reqVo);
        return PageResult.<KmsGrabRuleParamRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return kmsGrabRuleParamRespVo
     */
    @Override
    public KmsGrabRuleParamRespVo query(KmsGrabRuleParamReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(KmsGrabRuleParamReqVo reqVo){
        KmsGrabRuleParamEntity entity = CrmBeanUtil.copy(reqVo,KmsGrabRuleParamEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(KmsGrabRuleParamReqVo reqVo){
        KmsGrabRuleParamEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(KmsGrabRuleParamReqVo reqVo){
        List<KmsGrabRuleParamEntity> kmsGrabRuleParamEntities = kmsGrabRuleParamMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsGrabRuleParamEntities)){
            kmsGrabRuleParamEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(kmsGrabRuleParamEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(KmsGrabRuleParamReqVo reqVo){
        //设置状态为启用
        List<KmsGrabRuleParamEntity> kmsGrabRuleParamEntities = kmsGrabRuleParamMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsGrabRuleParamEntities)){
            kmsGrabRuleParamEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(kmsGrabRuleParamEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(KmsGrabRuleParamReqVo reqVo){
        //设置状态为禁用
        List<KmsGrabRuleParamEntity> kmsGrabRuleParamEntities = kmsGrabRuleParamMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsGrabRuleParamEntities)){
                kmsGrabRuleParamEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(kmsGrabRuleParamEntities);
    }
}
