package com.biz.crm.grabrule.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.grabrule.mapper.KmsGrabRuleStoreMapper;
import com.biz.crm.grabrule.model.KmsGrabRuleStoreEntity;
import com.biz.crm.grabrule.service.IKmsGrabRuleStoreService;
import com.biz.crm.nebular.kms.grabrule.req.KmsGrabRuleStoreReqVo;
import com.biz.crm.nebular.kms.grabrule.resp.KmsGrabRuleStoreRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 抓单规则门店配置表接口实现
 *
 * @author Gavin
 * @date 2021-04-16 17:00:42
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="KmsGrabRuleStoreServiceExpandImpl")
public class KmsGrabRuleStoreServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<KmsGrabRuleStoreMapper, KmsGrabRuleStoreEntity> implements IKmsGrabRuleStoreService {

    @Resource
    private KmsGrabRuleStoreMapper kmsGrabRuleStoreMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<KmsGrabRuleStoreRespVo> findList(KmsGrabRuleStoreReqVo reqVo){
        Page<KmsGrabRuleStoreRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<KmsGrabRuleStoreRespVo> list = kmsGrabRuleStoreMapper.findList(page, reqVo);
        return PageResult.<KmsGrabRuleStoreRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return kmsGrabRuleStoreRespVo
     */
    @Override
    public KmsGrabRuleStoreRespVo query(KmsGrabRuleStoreReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(KmsGrabRuleStoreReqVo reqVo){
        KmsGrabRuleStoreEntity entity = CrmBeanUtil.copy(reqVo,KmsGrabRuleStoreEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(KmsGrabRuleStoreReqVo reqVo){
        KmsGrabRuleStoreEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(KmsGrabRuleStoreReqVo reqVo){
        List<KmsGrabRuleStoreEntity> kmsGrabRuleStoreEntities = kmsGrabRuleStoreMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsGrabRuleStoreEntities)){
            kmsGrabRuleStoreEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(kmsGrabRuleStoreEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(KmsGrabRuleStoreReqVo reqVo){
        //设置状态为启用
        List<KmsGrabRuleStoreEntity> kmsGrabRuleStoreEntities = kmsGrabRuleStoreMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsGrabRuleStoreEntities)){
            kmsGrabRuleStoreEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(kmsGrabRuleStoreEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(KmsGrabRuleStoreReqVo reqVo){
        //设置状态为禁用
        List<KmsGrabRuleStoreEntity> kmsGrabRuleStoreEntities = kmsGrabRuleStoreMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsGrabRuleStoreEntities)){
                kmsGrabRuleStoreEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(kmsGrabRuleStoreEntities);
    }

    /**
     * 根据抓单规则获取门店列表
     * @param ruleId
     * @return
     */
    @Override
    public List<KmsGrabRuleStoreRespVo> findByGrabRuleId(String ruleId) {
        return this.kmsGrabRuleStoreMapper.findByGrabRuleId(ruleId);
    }
}
