package com.biz.crm.grabrule.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.config.KmsConfig;
import com.biz.crm.core.xxllog.XxlJobLogger;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.kms.KmsAdminEnum;
import com.biz.crm.grabrule.helper.KmsGrabRuleHelper;
import com.biz.crm.grabrule.helper.KmsRequestHelper;
import com.biz.crm.grabrule.mapper.KmsDataAuthMapper;
import com.biz.crm.grabrule.mapper.KmsGrabRuleMapper;
import com.biz.crm.grabrule.mapper.KmsLoggerDataProcessMapper;
import com.biz.crm.grabrule.mapper.KmsRequestMapper;
import com.biz.crm.grabrule.model.KmsDataAuthEntity;
import com.biz.crm.grabrule.model.KmsLoggerDataProcessEntity;
import com.biz.crm.grabrule.model.KmsRequestEntity;
import com.biz.crm.grabrule.service.IKmsRequestService;
import com.biz.crm.nebular.kms.grabrule.req.KmsGrabRuleReqVo;
import com.biz.crm.nebular.kms.grabrule.resp.KmsGrabRuleRespVo;
import com.biz.crm.supermarket.mapper.KmsTenantryDirectAccountMapper;
import com.biz.crm.supermarket.mapper.KmsTenantryDirectStoreMapper;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.UUID;

/**
 * @Project crm
 * @PackageName com.biz.crm.grabrule.service.impl
 * @ClassName KmsRequestServiceImpl
 * @Author Gavin
 * @Date 2021/4/21 下午4:42
 * @Description 抓单请求数据
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="KmsRequestServiceImpl")
public class KmsRequestServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<KmsRequestMapper, KmsRequestEntity> implements IKmsRequestService {

    @Resource
    private KmsGrabRuleMapper kmsGrabRuleMapper;

    @Resource
    private KmsTenantryDirectAccountMapper kmsAccountMapper;

    @Resource
    private KmsTenantryDirectStoreMapper kmsTenantryDirectStoreMapper;

    @Resource
    private KmsRequestHelper kmsRequestHelper;

    @Resource
    private KmsDataAuthMapper kmsDataAuthMapper;

    @Resource
    private KmsGrabRuleHelper kmsGrabRuleHelper;

    @Resource
    private KmsConfig kmsConfig;

    @Resource
    private KmsLoggerDataProcessMapper kmsLoggerDataProcessMapper;

    /**
     * 新增抓单请求
     * @param param
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(String grabId) {
        log.info("抓单请求参数抓单规则ID：{}",grabId);
        KmsAdminEnum.AutoType auto = KmsAdminEnum.AutoType.AUTO;
        //查询抓单规则配置
        KmsGrabRuleReqVo param = new KmsGrabRuleReqVo();
        param.setId(grabId);
        param.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        KmsGrabRuleRespVo grabRuleRespVo = kmsGrabRuleMapper.findById(param);
        if(ObjectUtils.isEmpty(grabRuleRespVo)){
            return;
        }
        String trackId = String.join("<=>", auto.getDescription()
                , kmsConfig.getTenantryId()
                , grabRuleRespVo.getRuleName()
                , DateTimeFormatter.ofPattern("yyyyMMddHHmmss").format(LocalDateTime.now()));
        //原始数据ID
        String rawDataId = UUID.randomUUID().toString().replaceAll("-", "");
        grabRuleRespVo.setRawDataId(rawDataId);
        //规则ID
        String grabRuleEntityId = grabRuleRespVo.getId();
        /*----抓单参数----*/
        JSONObject reqParm = kmsRequestHelper.buildReqPams(grabRuleEntityId);
        /*----抓单门店----*/
        kmsRequestHelper.buildReqPamStore(reqParm,grabRuleEntityId,grabRuleRespVo.getIsAllStore());
        /*----公共参数----*/
        kmsRequestHelper.buildCommonReqPams(reqParm,grabRuleRespVo);
        /*----扩展参数----*/
        JSONObject extendParm = kmsRequestHelper.buildExtendParms(grabRuleRespVo,trackId,auto);
        /*----最终参数构成----*/
        JSONObject request = kmsRequestHelper.buildRequest(reqParm,extendParm);
        //保存数据信息
        KmsRequestEntity entity = kmsRequestHelper.buildRequestEntity(grabRuleRespVo,request,auto);
        this.save(entity);
        //保存数据权限表数据（用于处理单据数据权限）
        KmsDataAuthEntity authEntity = kmsRequestHelper.buildAuthEntity(grabRuleRespVo);
        kmsDataAuthMapper.insert(authEntity);
        //保存抓单日志
        KmsLoggerDataProcessEntity loggerEntity = kmsRequestHelper.buildLogger(grabRuleRespVo,auto);
        loggerEntity.setRequest(entity.getRequest());
        kmsLoggerDataProcessMapper.insert(loggerEntity);
        XxlJobLogger.log("抓单请求已经保存到数据库中，时间：[{}]追踪ID：[{}]"
                ,DateTimeFormatter.ofPattern("yyyyMMddHHmmss").format(LocalDateTime.now()),trackId);
    }

    /**
     * 手动抓单
     * @param reqVo
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void manualGrab(KmsGrabRuleReqVo reqVo) {
        KmsAdminEnum.AutoType manual = KmsAdminEnum.AutoType.MANUAL;
        //参数校验
        kmsGrabRuleHelper.check(reqVo);
        KmsGrabRuleRespVo grabRuleRespVo = CrmBeanUtil.copy(reqVo,KmsGrabRuleRespVo.class);
        String trackId = String.join("<=>", manual.getDescription()
                , kmsConfig.getTenantryId()
                , grabRuleRespVo.getRuleName()
                , DateTimeFormatter.ofPattern("yyyyMMddHHmmss").format(LocalDateTime.now()));
        //原始数据ID
        String rawDataId = UUID.randomUUID().toString().replaceAll("-", "");
        grabRuleRespVo.setRawDataId(rawDataId);
        grabRuleRespVo.setNickName(UserUtils.getUser().getRealname());
        //规则ID
        String grabRuleEntityId = grabRuleRespVo.getId();
        /*----抓单参数----*/
        JSONObject reqParm = kmsRequestHelper.buildManualGrabReqPams(reqVo);
        /*----抓单门店----*/
        kmsRequestHelper.buildReqPamStore(reqParm,grabRuleEntityId,grabRuleRespVo.getIsAllStore());
        /*----公共参数----*/
        kmsRequestHelper.buildCommonReqPams(reqParm,grabRuleRespVo);
        /*----扩展参数----*/
        JSONObject extendParm = kmsRequestHelper.buildExtendParms(grabRuleRespVo,trackId,manual);
        /*----最终参数构成----*/
        JSONObject request = kmsRequestHelper.buildRequest(reqParm,extendParm);
        //保存数据信息
        KmsRequestEntity entity = kmsRequestHelper.buildRequestEntity(grabRuleRespVo,request,manual);
        this.save(entity);
        //保存数据权限表数据（用于处理单据数据权限）
        KmsDataAuthEntity authEntity = kmsRequestHelper.buildAuthEntity(grabRuleRespVo);
        kmsDataAuthMapper.insert(authEntity);
        //保存抓单日志
        KmsLoggerDataProcessEntity loggerEntity = kmsRequestHelper.buildLogger(grabRuleRespVo,manual);
        loggerEntity.setRequest(entity.getRequest());
        kmsLoggerDataProcessMapper.insert(loggerEntity);
    }
}