package com.biz.crm.jobhandler;

import com.biz.crm.acceptanceform.service.IKmsAcceptanceFormService;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.GlobalParam;
import com.biz.crm.common.param.RedisParam;
import com.biz.crm.config.KmsConfig;
import com.biz.crm.core.biz.model.ReturnT;
import com.biz.crm.core.handler.annotation.XxlJob;
import com.biz.crm.core.xxllog.XxlJobLogger;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.kms.KmsEnum;
import com.biz.crm.eunm.mdm.LoginFromTypeEnum;
import com.biz.crm.finance.service.IKmsAuditFormService;
import com.biz.crm.finance.service.IKmsAuditTemplateService;
import com.biz.crm.grabrule.service.IKmsRequestService;
import com.biz.crm.mdm.user.MdmUserFeign;
import com.biz.crm.nebular.kms.finance.req.KmsAuditFormReqVo;
import com.biz.crm.nebular.kms.finance.req.KmsAuditTemplateReqVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditFormRespVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditTemplateRespVo;
import com.biz.crm.nebular.kms.rawdata.req.*;
import com.biz.crm.nebular.kms.rawdata.resp.*;
import com.biz.crm.nebular.kms.sap.req.KmsSapOrderFormReqVo;
import com.biz.crm.nebular.kms.supermarket.req.KmsTenantryDirectCustomerOrgReqVo;
import com.biz.crm.nebular.kms.supermarket.resp.KmsTenantryDirectCustomerOrgRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.orderform.service.IKmsOrderFormService;
import com.biz.crm.rawdata.model.*;
import com.biz.crm.rawdata.service.*;
import com.biz.crm.returnform.service.IKmsReturnFormService;
import com.biz.crm.salesdata.service.IKmsSalesDataService;
import com.biz.crm.stockdata.service.IKmsStockDataService;
import com.biz.crm.supermarket.mapper.KmsTenantryDirectCustomerOrgMapper;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.KmsOrgUtil;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

/**
 * @Project crm
 * @PackageName com.biz.crm.executor.jobhandler
 * @ClassName KmsXxlJob
 * @Author Gavin
 * @Date 2021/4/20 下午4:03
 * @Description 抓单任务
 */
@Slf4j
@Component
public class KmsXxlJob {

    @Resource
    private IKmsRequestService kmsRequestService;

    @Resource
    private IKmsOrderFormService kmsOrderFormService;

    @Resource
    private IKmsOrderFormDetailDwService kmsOrderFormDetailDwService;

    @Resource
    private IKmsAcceptanceFormService kmsAcceptanceFormService;

    @Resource
    private IKmsAcceptanceFormDetailDwService kmsAcceptanceFormDetailDwService;

    @Resource
    private IKmsReturnFormService kmsReturnFormService;

    @Resource
    private IKmsReturnFormDetailDwService kmsReturnFormDetailDwService;

    @Resource
    private IKmsAuditTemplateService kmsAuditTemplateService;

    @Resource
    private IKmsAuditFormService kmsAuditFormService;

    @Resource
    private KmsConfig kmsConfig;

    @Resource
    private MdmUserFeign mdmUserFeign;

    @Resource
    private KmsTenantryDirectCustomerOrgMapper tenantryDirectCustomerOrgMapper;

    @Resource
    private IKmsSaleDataFormDetailDwService kmsSaleDataFormDetailDwService;

    @Resource
    private IKmsInventoryDataFormDetailDwService kmsInventoryDataFormDetailDwService;

    @Resource
    private IKmsSalesDataService kmsSalesDataService;

    @Resource
    private IKmsStockDataService kmsStockDataService;

    /**
     * 自动抓单
     */
    @XxlJob("kmsJobHandler")
    public ReturnT<String> demoJobHandler(String param) {
        try {
            if (!StringUtils.isEmpty(param)) {
                kmsRequestService.save(param);
            }
        } catch (Exception e) {
            XxlJobLogger.log(e);
            return ReturnT.FAIL;
        }
        return ReturnT.SUCCESS;
    }

    /**
     * 原始订货单数据转换
     *
     * @param param
     * @return
     */
    @XxlJob("kmsOrderFormTransJobHandler")
    public ReturnT<String> kmsOrderFormTransJobHandler(String param) {
        UserUtils.doTokenForNull();
        StringBuilder sb = new StringBuilder("");
        try {
            //查询待转换单据信息
            KmsOrderFormDetailDwReqVo params = new KmsOrderFormDetailDwReqVo();
            params.setTransStatus(YesNoEnum.yesNoEnum.ZERO.getValue());
            List<KmsOrderFormDetailDwRespVo> dwRespVos = kmsOrderFormDetailDwService.findNotTransData(params);
            dwRespVos.forEach(o -> {
                try {
                    kmsOrderFormService.autoTransData(o);
                } catch (Exception e) {
                    sb.append("单据[" + o.getOrderNumber() + "]-[" + o.getCreateCode() + "]" + e.getMessage() + "-" + stackMsg(e.getStackTrace(), null) + " | ");
                    //修改状态为失败
                    kmsOrderFormDetailDwService.lambdaUpdate()
                            .eq(KmsOrderFormDetailDwEntity::getOrderNumber, o.getOrderNumber())
                            .set(KmsOrderFormDetailDwEntity::getTransStatus, "-1")
                            .update();
                }
            });
        } catch (Exception e) {
            XxlJobLogger.log(e);
            return ReturnT.FAIL;
        }
        String msg = sb.toString();
        if (StringUtils.isEmpty(msg)) {
            return ReturnT.SUCCESS;
        } else {
            XxlJobLogger.log("失败信息：" + msg);
            return ReturnT.FAIL;
        }
    }

    /**
     * 原始验收单数据转换
     *
     * @param param
     * @return
     */
    @XxlJob("kmsAcceptanceFormTransJobHandler")
    public ReturnT<String> kmsAcceptanceFormTransJobHandler(String param) {
        UserUtils.doTokenForNull();
        StringBuilder sb = new StringBuilder("");
        try {
            //查询待转换单据信息
            KmsAcceptanceFormDetailDwReqVo params = new KmsAcceptanceFormDetailDwReqVo();
            params.setTransStatus(YesNoEnum.yesNoEnum.ZERO.getValue());
            List<KmsAcceptanceFormDetailDwRespVo> dwRespVos = kmsAcceptanceFormDetailDwService.findNotTransData(params);
            dwRespVos.forEach(o -> {
                try {
                    kmsAcceptanceFormService.autoTransData(o);
                } catch (Exception e) {
                    sb.append("单据[" + o.getOrderNumber() + "]-[" + o.getCreateCode() + "]" + e.getMessage() + "-" + stackMsg(e.getStackTrace(), null) + " | ");
                    //修改状态为失败
                    kmsAcceptanceFormDetailDwService.lambdaUpdate()
                            .eq(KmsAcceptanceFormDetailDwEntity::getOrderNumber, o.getOrderNumber())
                            .set(KmsAcceptanceFormDetailDwEntity::getTransStatus, "-1")
                            .update();
                }
            });
        } catch (Exception e) {
            XxlJobLogger.log(e);
            return ReturnT.FAIL;
        }
        String msg = sb.toString();
        if (StringUtils.isEmpty(msg)) {
            return ReturnT.SUCCESS;
        } else {
            XxlJobLogger.log("失败信息：" + msg);
            return ReturnT.FAIL;
        }
    }

    /**
     * 原始退货单数据转换
     *
     * @param param
     * @return
     */
    @XxlJob("kmsReturnFormTransJobHandler")
    public ReturnT<String> kmsReturnFormTransJobHandler(String param) {
        UserUtils.doTokenForNull();
        StringBuilder sb = new StringBuilder("");
        try {
            //查询待转换单据信息
            KmsReturnFormDetailDwReqVo params = new KmsReturnFormDetailDwReqVo();
            params.setTransStatus(YesNoEnum.yesNoEnum.ZERO.getValue());
            List<KmsReturnFormDetailDwRespVo> orderNumbers = kmsReturnFormDetailDwService.findNotTransData(params);
            orderNumbers.forEach(o -> {
                try {
                    kmsReturnFormService.autoTransData(o);
                } catch (Exception e) {
                    sb.append("单据[" + o.getOrderNumber() + "]-[" + o.getCreateCode() + "]" + e.getMessage() + "-" + stackMsg(e.getStackTrace(), null) + " | ");
                    //修改状态为失败
                    kmsReturnFormDetailDwService.lambdaUpdate()
                            .eq(KmsReturnFormDetailDwEntity::getOrderNumber, o.getOrderNumber())
                            .set(KmsReturnFormDetailDwEntity::getTransStatus, "-1")
                            .update();
                }
            });
        } catch (Exception e) {
            XxlJobLogger.log(e);
            return ReturnT.FAIL;
        }
        String msg = sb.toString();
        if (StringUtils.isEmpty(msg)) {
            return ReturnT.SUCCESS;
        } else {
            XxlJobLogger.log("失败信息：" + msg);
            return ReturnT.FAIL;
        }
    }

    /**
     * 原始销售数据转换
     *
     * @param param
     * @return
     */
    @XxlJob("kmsSaleDataTransJobHandler")
    public ReturnT<String> kmsSaleDataTransJobHandler(String param) {
        UserUtils.doTokenForNull();
        StringBuilder sb = new StringBuilder("");
        try {
            //查询待转换单据信息
            KmsSaleDataFormDetailDwReqVo params = new KmsSaleDataFormDetailDwReqVo();
            params.setTransStatus(YesNoEnum.yesNoEnum.ZERO.getValue());
            List<KmsSaleDataFormDetailDwRespVo> detailDwRespVos = kmsSaleDataFormDetailDwService.findNotTransData(params);
            detailDwRespVos.forEach(o -> {
                try {
                    kmsSalesDataService.autoTransData(o);
                } catch (Exception e) {
                    sb.append("单据[" + o.getOrderNumber() + "]-[" + o.getCreateCode() + "]" + e.getMessage() + "-" + stackMsg(e.getStackTrace(), null) + " | ");
                    //修改状态为失败
                    kmsSaleDataFormDetailDwService.lambdaUpdate()
                            .eq(KmsSaleDataFormDetailDwEntity::getOrderNumber, o.getOrderNumber())
                            .set(KmsSaleDataFormDetailDwEntity::getTransStatus, "-1")
                            .update();
                }
            });
        } catch (Exception e) {
            XxlJobLogger.log(e);
            return ReturnT.FAIL;
        }
        String msg = sb.toString();
        if (StringUtils.isEmpty(msg)) {
            return ReturnT.SUCCESS;
        } else {
            XxlJobLogger.log("失败信息：" + msg);
            return ReturnT.FAIL;
        }
    }

    /**
     * 原始库存数据转换
     *
     * @param param
     * @return
     */
    @XxlJob("kmsStockDataTransJobHandler")
    public ReturnT<String> kmsStockDataTransJobHandler(String param) {
        UserUtils.doTokenForNull();
        StringBuilder sb = new StringBuilder("");
        try {
            //查询待转换单据信息
            KmsInventoryDataFormDetailDwReqVo params = new KmsInventoryDataFormDetailDwReqVo();
            params.setTransStatus(YesNoEnum.yesNoEnum.ZERO.getValue());
            List<KmsInventoryDataFormDetailDwRespVo> orderNumbers = kmsInventoryDataFormDetailDwService.findNotTransData(params);
            orderNumbers.forEach(o -> {
                try {
                    kmsStockDataService.autoTransData(o);
                } catch (Exception e) {
                    sb.append("单据[" + o.getOrderNumber() + "]-[" + o.getCreateCode() + "]" + e.getMessage() + "-" + stackMsg(e.getStackTrace(), null) + " | ");
                    //修改状态为失败
                    kmsInventoryDataFormDetailDwService.lambdaUpdate()
                            .eq(KmsInventoryDataFormDetailDwEntity::getOrderNumber, o.getOrderNumber())
                            .set(KmsInventoryDataFormDetailDwEntity::getTransStatus, "-1")
                            .update();
                }
            });
        } catch (Exception e) {
            XxlJobLogger.log(e);
            return ReturnT.FAIL;
        }
        String msg = sb.toString();
        if (StringUtils.isEmpty(msg)) {
            return ReturnT.SUCCESS;
        } else {
            XxlJobLogger.log("失败信息：" + msg);
            return ReturnT.FAIL;
        }
    }

    /**
     * 抽取SAP发票数据
     *
     * @param param
     * @return
     */
    @XxlJob("kmsPullSapJobHandler")
    public ReturnT<String> pullSap(String param) {
        StringBuilder sb = new StringBuilder("");
        try {
            //查询所有有效稽核模版
            KmsAuditTemplateReqVo templateReqVo = new KmsAuditTemplateReqVo();
            templateReqVo.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
            templateReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            List<KmsAuditTemplateRespVo> auditTemplateRespAll = kmsAuditTemplateService.findAll(templateReqVo);
            List<KmsAuditTemplateRespVo> templateRespVos = auditTemplateRespAll.stream()
                    .filter(o -> !CollectionUtils.isEmpty(o.getDirectVos()))
                    .collect(Collectors.toList());
            AssertUtils.isNotEmpty(templateRespVos, "未查询到模版信息");
            //参数
            KmsSapOrderFormReqVo kmsSapOrderFormReqVo = new KmsSapOrderFormReqVo();
            //设置抓取日期
            Calendar cl = Calendar.getInstance();
            cl.add(Calendar.DAY_OF_MONTH, -1);
            kmsSapOrderFormReqVo.setInvoiceCreateTime(DateUtil.formatDate(cl));
            //直营体系数据
            Map<String, KmsTenantryDirectCustomerOrgRespVo> customerOrgRespVoMap = Maps.newHashMap();
            templateRespVos.forEach(o -> {
                try {
                    String token = UUID.randomUUID().toString().replaceAll("-", "");
                    UserUtils.createUserToRedis(token, o.getCreateCode(), o.getCreatePosCode(), LoginFromTypeEnum.TEMPORARY.getValue(), RedisParam.SECONDS_OF_HOUR);
                    MdmOrgRespVo companyOrg = KmsOrgUtil.getCompanyOrg(o.getCreateOrgCode());
                    AssertUtils.isNotNull(companyOrg, "模版[" + o.getTemplateName() + "]没有所属公司信息!");
                    o.setSapOrgCode(companyOrg.getSapOrgCode());
                    o.setOrgCode(companyOrg.getOrgCode());
                    ConcurrentHashMap<String, Object> map = ThreadLocalUtil.get();
                    map.put(GlobalParam.FUNCTION_CODE, kmsConfig.getFunctionCode());
                    map.put(GlobalParam.MENU_CODE, kmsConfig.getMenuCode());
                    templateReqVo.setId(o.getId());
                    List<KmsAuditTemplateRespVo> auditTemplate = kmsAuditTemplateService.findAll(templateReqVo);
                    KmsAuditTemplateRespVo auditTemplateRespVo = auditTemplate.get(0);
                    auditTemplateRespVo.setSapOrgCode(companyOrg.getSapOrgCode());
                    auditTemplateRespVo.setOrgCode(companyOrg.getOrgCode());
                    List<KmsAuditTemplateRespVo> auditTemplateRespVos = Lists.newArrayList();
                    auditTemplateRespVos.add(auditTemplateRespVo);
                    auditTemplateRespVo.getDirectVos().forEach(ka -> {
                        try {
                            //通过商超ID查询直营体系
                            KmsTenantryDirectCustomerOrgReqVo customerOrgReqVo = new KmsTenantryDirectCustomerOrgReqVo();
                            customerOrgReqVo.setDirectId(ka.getDirectId());
                            customerOrgReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                            List<KmsTenantryDirectCustomerOrgRespVo> customerOrgMapperList = tenantryDirectCustomerOrgMapper.findList(customerOrgReqVo);
                            customerOrgMapperList.forEach(c -> {
                                kmsSapOrderFormReqVo.setBsDirectSystemId(c.getId());
                                kmsSapOrderFormReqVo.setAuditTemplateVo(auditTemplateRespVos);
                                KmsTenantryDirectCustomerOrgRespVo cuOrg = customerOrgRespVoMap.get(c.getBsDirectSystemId());
                                if (ObjectUtils.isEmpty(cuOrg)) {
                                    kmsAuditFormService.pullSap(kmsSapOrderFormReqVo);
                                    customerOrgRespVoMap.put(c.getBsDirectSystemId(), c);
                                }
                                //汇总
                                if (!CollectionUtils.isEmpty(kmsSapOrderFormReqVo.getInvoiceIds())) {
                                    kmsAuditFormService.pullSapSummary(kmsSapOrderFormReqVo);
                                }
                            });
                        } catch (Exception e) {
                            sb.append(e.getMessage() + " | 模版[" + o.getTemplateName() + "]商超[" + ka.getDirectName() + "]抓取SAP失败");
                        }
                    });
                } catch (Exception e) {
                    sb.append(e.getMessage() + " | 模版[" + o.getTemplateName() + "]抓取SAP失败");
                } finally {
                    ThreadLocalUtil.delObj();
                    ThreadLocalUtil.deleteUser();
                }
            });
        } catch (Exception e) {
            XxlJobLogger.log(e);
            return ReturnT.FAIL;
        }
        String msg = sb.toString();
        if (StringUtils.isEmpty(msg)) {
            return ReturnT.SUCCESS;
        } else {
            XxlJobLogger.log("失败信息：" + msg);
            return ReturnT.FAIL;
        }
    }

    /**
     * 自动稽核匹配
     *
     * @param param
     * @return
     */
    @XxlJob("kmsAuditFormMatchJobHandler")
    public ReturnT<String> kmsAuditFormMatchJobHandler(String param) {
        StringBuilder sb = new StringBuilder("");
        try {
            //查询所有有效稽核模版
            KmsAuditTemplateReqVo templateReqVo = new KmsAuditTemplateReqVo();
            templateReqVo.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
            templateReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            List<KmsAuditTemplateRespVo> auditTemplateRespAll = kmsAuditTemplateService.findAll(templateReqVo);
            List<KmsAuditTemplateRespVo> templateRespVos = auditTemplateRespAll.stream()
                    .filter(o -> !CollectionUtils.isEmpty(o.getDirectVos()))
                    .collect(Collectors.toList());
            AssertUtils.isNotEmpty(templateRespVos, "未查询到模版信息");
            KmsAuditFormReqVo formReqVo = new KmsAuditFormReqVo();
            //设置抓取日期
            for (int i = -2, j = 0; i <= j; i++) {
                Calendar cl = Calendar.getInstance();
                cl.add(Calendar.DAY_OF_MONTH, i);
                formReqVo.setCreateDate(DateUtil.formatDate(cl));
                templateRespVos.forEach(o -> {
                    try {
                        String token = UUID.randomUUID().toString().replaceAll("-", "");
                        UserUtils.createUserToRedis(token, o.getCreateCode(), o.getCreatePosCode(), LoginFromTypeEnum.TEMPORARY.getValue(), RedisParam.SECONDS_OF_HOUR);
                        ConcurrentHashMap<String, Object> map = ThreadLocalUtil.get();
                        map.put(GlobalParam.FUNCTION_CODE, kmsConfig.getFunctionCode());
                        map.put(GlobalParam.MENU_CODE, kmsConfig.getMenuCode());
                        //查询模版下待匹配稽核数据信息
                        formReqVo.setAuditTemplateId(o.getId());
                        formReqVo.setIsAudit(YesNoEnum.yesNoEnum.no.getValue());
                        formReqVo.setAuditResult(KmsEnum.AuditStatus.WAIT.getValue());
                        formReqVo.setDesc("ASC");
                        templateReqVo.setId(o.getId());
                        KmsAuditTemplateRespVo templateRespVo = kmsAuditTemplateService.query(templateReqVo);
                        templateRespVo.getDirectVos().forEach(dir -> {
                            formReqVo.setBsDirectSystemId(dir.getBsDirectSystemId());
                            List<KmsAuditFormRespVo> kmsAuditFormRespVos = kmsAuditFormService.findWaitList(formReqVo);
                            kmsAuditFormRespVos.forEach(afVo -> {
                                try {
                                    kmsAuditFormService.auditMatch(afVo, templateRespVo);
                                    //处理延迟收货
                                    o.setRemarks("延迟收货");
                                    kmsAuditFormService.delayedReceipt(afVo, templateRespVo);
                                } catch (Exception e) {
                                    log.info(dir.getBsDirectSystemCode() + "-" + afVo.getAuditNumber() + "匹配异常：{}", e.getMessage());
                                    sb.append(e.getMessage() + " | ");
                                }
                            });
                        });
                    } catch (Exception e) {
                        sb.append(e.getMessage() + "-" + stackMsg(e.getStackTrace(), null) + " | ");
                    } finally {
                        ThreadLocalUtil.delObj();
                        ThreadLocalUtil.deleteUser();
                    }
                });
            }
        } catch (Exception e) {
            XxlJobLogger.log(e);
            return ReturnT.FAIL;
        }
        String msg = sb.toString();
        if (StringUtils.isEmpty(msg)) {
            return ReturnT.SUCCESS;
        } else {
            XxlJobLogger.log("失败信息：" + msg);
            return ReturnT.FAIL;
        }
    }

    /**
     * 获取异常信息
     *
     * @param stackTraceElements
     * @param filtration
     * @return
     */
    public static String stackMsg(StackTraceElement[] stackTraceElements, String filtration) {
        if (null == stackTraceElements || stackTraceElements.length < 1) {
            return null;
        }
        StringBuffer upMethodName = new StringBuffer();
        for (StackTraceElement stackTraceElement : stackTraceElements) {
            if (org.apache.commons.lang3.StringUtils.isNotEmpty(filtration)) {
                if (!stackTraceElement.getClassName().startsWith(filtration)) {
                    continue;
                }
            }
            upMethodName.append("\n\t res ");
            upMethodName.append(stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName() + "(" + stackTraceElement.getFileName() + ":" + stackTraceElement.getLineNumber() + ")");
        }

        return upMethodName.toString();
    }
}