package com.biz.crm.rawdata.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.kms.rawdata.req.KmsAcceptanceFormDetailDwReqVo;
import com.biz.crm.nebular.kms.rawdata.resp.KmsAcceptanceFormDetailDwRespVo;
import com.biz.crm.rawdata.mapper.KmsAcceptanceFormDetailDwMapper;
import com.biz.crm.rawdata.model.KmsAcceptanceFormDetailDwEntity;
import com.biz.crm.rawdata.service.IKmsAcceptanceFormDetailDwService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 验收单原始数据表接口实现
 *
 * @author Gavin
 * @date 2021-05-12 19:21:09
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="KmsAcceptanceFormDetailDwServiceExpandImpl")
public class KmsAcceptanceFormDetailDwServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<KmsAcceptanceFormDetailDwMapper, KmsAcceptanceFormDetailDwEntity> implements IKmsAcceptanceFormDetailDwService {

    @Resource
    private KmsAcceptanceFormDetailDwMapper kmsAcceptanceFormDetailDwMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<KmsAcceptanceFormDetailDwRespVo> findList(KmsAcceptanceFormDetailDwReqVo reqVo){
        Page<KmsAcceptanceFormDetailDwRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<KmsAcceptanceFormDetailDwRespVo> list = kmsAcceptanceFormDetailDwMapper.findList(page, reqVo);
        return PageResult.<KmsAcceptanceFormDetailDwRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return kmsAcceptanceFormDetailDwRespVo
     */
    @Override
    public KmsAcceptanceFormDetailDwRespVo query(KmsAcceptanceFormDetailDwReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(KmsAcceptanceFormDetailDwReqVo reqVo){
        KmsAcceptanceFormDetailDwEntity entity = CrmBeanUtil.copy(reqVo,KmsAcceptanceFormDetailDwEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(KmsAcceptanceFormDetailDwReqVo reqVo){
        KmsAcceptanceFormDetailDwEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(KmsAcceptanceFormDetailDwReqVo reqVo){
        List<KmsAcceptanceFormDetailDwEntity> kmsAcceptanceFormDetailDwEntities = kmsAcceptanceFormDetailDwMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsAcceptanceFormDetailDwEntities)){
            kmsAcceptanceFormDetailDwEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(kmsAcceptanceFormDetailDwEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(KmsAcceptanceFormDetailDwReqVo reqVo){
        //设置状态为启用
        List<KmsAcceptanceFormDetailDwEntity> kmsAcceptanceFormDetailDwEntities = kmsAcceptanceFormDetailDwMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsAcceptanceFormDetailDwEntities)){
            kmsAcceptanceFormDetailDwEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(kmsAcceptanceFormDetailDwEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(KmsAcceptanceFormDetailDwReqVo reqVo){
        //设置状态为禁用
        List<KmsAcceptanceFormDetailDwEntity> kmsAcceptanceFormDetailDwEntities = kmsAcceptanceFormDetailDwMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsAcceptanceFormDetailDwEntities)){
                kmsAcceptanceFormDetailDwEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(kmsAcceptanceFormDetailDwEntities);
    }

    /**
     * 查询待转换单据信息
     * @param params
     * @return
     */
    @Override
    public List<KmsAcceptanceFormDetailDwRespVo> findNotTransData(KmsAcceptanceFormDetailDwReqVo params) {
        return kmsAcceptanceFormDetailDwMapper.findNotTransData(params);
    }
}
