package com.biz.crm.rawdata.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.kms.rawdata.req.KmsOrderGoodsDetailDwReqVo;
import com.biz.crm.nebular.kms.rawdata.resp.KmsOrderGoodsDetailDwRespVo;
import com.biz.crm.rawdata.mapper.KmsOrderGoodsDetailDwMapper;
import com.biz.crm.rawdata.model.KmsOrderGoodsDetailDwEntity;
import com.biz.crm.rawdata.service.IKmsOrderGoodsDetailDwService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 原单订单行数据信息接口实现
 *
 * @author Gavin
 * @date 2021-05-12 19:21:10
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="KmsOrderGoodsDetailDwServiceExpandImpl")
public class KmsOrderGoodsDetailDwServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<KmsOrderGoodsDetailDwMapper, KmsOrderGoodsDetailDwEntity> implements IKmsOrderGoodsDetailDwService {

    @Resource
    private KmsOrderGoodsDetailDwMapper kmsOrderGoodsDetailDwMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<KmsOrderGoodsDetailDwRespVo> findList(KmsOrderGoodsDetailDwReqVo reqVo){
        Page<KmsOrderGoodsDetailDwRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<KmsOrderGoodsDetailDwRespVo> list = kmsOrderGoodsDetailDwMapper.findList(page, reqVo);
        return PageResult.<KmsOrderGoodsDetailDwRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return kmsOrderGoodsDetailDwRespVo
     */
    @Override
    public KmsOrderGoodsDetailDwRespVo query(KmsOrderGoodsDetailDwReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(KmsOrderGoodsDetailDwReqVo reqVo){
        KmsOrderGoodsDetailDwEntity entity = CrmBeanUtil.copy(reqVo,KmsOrderGoodsDetailDwEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(KmsOrderGoodsDetailDwReqVo reqVo){
        KmsOrderGoodsDetailDwEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(KmsOrderGoodsDetailDwReqVo reqVo){
        List<KmsOrderGoodsDetailDwEntity> kmsOrderGoodsDetailDwEntities = kmsOrderGoodsDetailDwMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsOrderGoodsDetailDwEntities)){
            kmsOrderGoodsDetailDwEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(kmsOrderGoodsDetailDwEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(KmsOrderGoodsDetailDwReqVo reqVo){
        //设置状态为启用
        List<KmsOrderGoodsDetailDwEntity> kmsOrderGoodsDetailDwEntities = kmsOrderGoodsDetailDwMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsOrderGoodsDetailDwEntities)){
            kmsOrderGoodsDetailDwEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(kmsOrderGoodsDetailDwEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(KmsOrderGoodsDetailDwReqVo reqVo){
        //设置状态为禁用
        List<KmsOrderGoodsDetailDwEntity> kmsOrderGoodsDetailDwEntities = kmsOrderGoodsDetailDwMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsOrderGoodsDetailDwEntities)){
                kmsOrderGoodsDetailDwEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(kmsOrderGoodsDetailDwEntities);
    }
}
