package com.biz.crm.returnform.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.kms.returnform.req.KmsReturnGoodsReqVo;
import com.biz.crm.nebular.kms.returnform.resp.KmsReturnGoodsRespVo;
import com.biz.crm.returnform.model.KmsReturnGoodsEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 退货单详情表
 * 
 * @author Gavin
 * @date 2021-05-12 18:23:07
 */
public interface KmsReturnGoodsMapper extends BaseMapper<KmsReturnGoodsEntity> {
    /**
     * 列表
     * @param page
     * @param kmsReturnGoodsReqVo
     * @return
     */
    @SqlPrivilege(posCode = "t.create_pos_code",orgCode = "t.create_org_code")
    List<KmsReturnGoodsRespVo> findList(Page<KmsReturnGoodsRespVo> page, @Param("vo") KmsReturnGoodsReqVo kmsReturnGoodsReqVo);

}
