package com.biz.crm.returnform.service;

import com.biz.crm.returnform.model.KmsReturnGoodsEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.kms.returnform.resp.KmsReturnGoodsRespVo;
import com.biz.crm.nebular.kms.returnform.req.KmsReturnGoodsReqVo;

import java.util.Map;

/**
 * 退货单详情表接口
 *
 * @author Gavin
 * @date 2021-05-12 18:23:07
 */
public interface IKmsReturnGoodsService extends IService<KmsReturnGoodsEntity> {

    /**
     * 列表
     * @param kmsReturnGoodsReqVo
     * @return PageResult<KmsReturnGoodsRespVo>
     */
    PageResult<KmsReturnGoodsRespVo> findList(KmsReturnGoodsReqVo kmsReturnGoodsReqVo);

    /**
     * 查询
     * @param kmsReturnGoodsReqVo
     * @return KmsReturnGoodsRespVo
     */
    KmsReturnGoodsRespVo query(KmsReturnGoodsReqVo kmsReturnGoodsReqVo);

    /**
     * 新增
     * @param kmsReturnGoodsReqVo
     * @return
     */
    void save(KmsReturnGoodsReqVo kmsReturnGoodsReqVo);

    /**
     * 更新
     * @param kmsReturnGoodsReqVo
     * @return
     */
    void update(KmsReturnGoodsReqVo kmsReturnGoodsReqVo);

    /**
     * 删除
     * @param kmsReturnGoodsReqVo
     * @return
     */
    void deleteBatch(KmsReturnGoodsReqVo kmsReturnGoodsReqVo);

    /**
     * 启用
     * @param kmsReturnGoodsReqVo
     * @return
     */
    void enableBatch(KmsReturnGoodsReqVo kmsReturnGoodsReqVo);

    /**
     * 禁用
     * @param kmsReturnGoodsReqVo
     * @return
     */
    void disableBatch(KmsReturnGoodsReqVo kmsReturnGoodsReqVo);
}

