package com.biz.crm.returnform.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.kms.returnform.req.KmsReturnStatusRecordReqVo;
import com.biz.crm.nebular.kms.returnform.resp.KmsReturnStatusRecordRespVo;
import com.biz.crm.returnform.mapper.KmsReturnStatusRecordMapper;
import com.biz.crm.returnform.model.KmsReturnFormEntity;
import com.biz.crm.returnform.model.KmsReturnStatusRecordEntity;
import com.biz.crm.returnform.service.IKmsReturnStatusRecordService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 退货单状态记录表接口实现
 *
 * @author Gavin
 * @date 2021-05-12 18:23:07
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="KmsReturnStatusRecordServiceExpandImpl")
public class KmsReturnStatusRecordServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<KmsReturnStatusRecordMapper, KmsReturnStatusRecordEntity> implements IKmsReturnStatusRecordService {

    @Resource
    private KmsReturnStatusRecordMapper kmsReturnStatusRecordMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<KmsReturnStatusRecordRespVo> findList(KmsReturnStatusRecordReqVo reqVo){
        Page<KmsReturnStatusRecordRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<KmsReturnStatusRecordRespVo> list = kmsReturnStatusRecordMapper.findList(page, reqVo);
        return PageResult.<KmsReturnStatusRecordRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return kmsReturnStatusRecordRespVo
     */
    @Override
    public KmsReturnStatusRecordRespVo query(KmsReturnStatusRecordReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(KmsReturnStatusRecordReqVo reqVo){
        KmsReturnStatusRecordEntity entity = CrmBeanUtil.copy(reqVo,KmsReturnStatusRecordEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(KmsReturnStatusRecordReqVo reqVo){
        KmsReturnStatusRecordEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(KmsReturnStatusRecordReqVo reqVo){
        List<KmsReturnStatusRecordEntity> kmsReturnStatusRecordEntities = kmsReturnStatusRecordMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsReturnStatusRecordEntities)){
            kmsReturnStatusRecordEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(kmsReturnStatusRecordEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(KmsReturnStatusRecordReqVo reqVo){
        //设置状态为启用
        List<KmsReturnStatusRecordEntity> kmsReturnStatusRecordEntities = kmsReturnStatusRecordMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsReturnStatusRecordEntities)){
            kmsReturnStatusRecordEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(kmsReturnStatusRecordEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(KmsReturnStatusRecordReqVo reqVo){
        //设置状态为禁用
        List<KmsReturnStatusRecordEntity> kmsReturnStatusRecordEntities = kmsReturnStatusRecordMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsReturnStatusRecordEntities)){
                kmsReturnStatusRecordEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(kmsReturnStatusRecordEntities);
    }

    @Override
    public void insert(List<KmsReturnFormEntity> returnFormEntities) {
        List<KmsReturnStatusRecordEntity> recordEntities = CrmBeanUtil.copyList(returnFormEntities,KmsReturnStatusRecordEntity.class);
        recordEntities.forEach(o -> {
            setNull(o);
        });
        this.saveBatch(recordEntities);
    }

    private void setNull(KmsReturnStatusRecordEntity o) {
        o.setId(null);
        o.setCreateDate(null);
        o.setCreateDateAll(null);
        o.setCreateDateSecond(null);
        o.setUpdateDateAll(null);
        o.setUpdateDateSecond(null);
        o.setUpdateDate(null);
    }

    @Override
    public void insert(KmsReturnFormEntity returnFormEntity) {
        KmsReturnStatusRecordEntity recordEntity = CrmBeanUtil.copy(returnFormEntity,KmsReturnStatusRecordEntity.class);
        setNull(recordEntity);
        this.save(recordEntity);
    }
}
