package com.biz.crm.supermarket.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.kms.supermarket.req.KmsTotalWarehouseStoreReqVo;
import com.biz.crm.nebular.kms.supermarket.resp.KmsTotalWarehouseStoreRespVo;
import com.biz.crm.supermarket.model.KmsTotalWarehouseStoreEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 总仓门店
 *
 * @author lf
 * @date 2021-06-26 11:20:06
 */
public interface KmsTotalWarehouseStoreMapper extends BaseMapper<KmsTotalWarehouseStoreEntity> {
    /**
     * 列表
     *
     * @param page
     * @param kmsTotalWarehouseStoreReqVo
     * @return
     */
    @SqlPrivilege(posCode = "t.create_pos_code", orgCode = "t.create_org_code")
    List<KmsTotalWarehouseStoreRespVo> findList(Page<KmsTotalWarehouseStoreRespVo> page, @Param("vo") KmsTotalWarehouseStoreReqVo kmsTotalWarehouseStoreReqVo);

    /**
     * 数据检验 判断重复
     *
     * @param reqVo
     * @return
     */
    @SqlPrivilege(posCode = "t.create_pos_code", orgCode = "t.create_org_code")
    List<KmsTotalWarehouseStoreEntity> selectListWithDataPurview(@Param("vo") KmsTotalWarehouseStoreReqVo reqVo);

    /**
     * 判断是否属于大仓 根据物料类型、门店、商超 物料查询
     * @param reqVo
     * @return
     */
    @SqlPrivilege(posCode = "t.create_pos_code", orgCode = "t.create_org_code")
    List<KmsTotalWarehouseStoreRespVo> findTotalStoreList(@Param("vo") KmsTotalWarehouseStoreReqVo reqVo);
}
