package com.biz.crm.supermarket.service;


import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.kms.supermarket.req.KmsTenantryDirectCustomerOrgReqVo;
import com.biz.crm.nebular.kms.supermarket.resp.KmsTenantryDirectCustomerOrgRespVo;
import com.biz.crm.nebular.mdm.cusorg.CusOrgVo;
import com.biz.crm.nebular.mdm.cusorg.MdmCustomerOrgSelectRespVo;
import com.biz.crm.supermarket.model.KmsTenantryDirectCustomerOrgEntity;

import java.util.List;

/**
 * 客户组织与抓单商超（直营体系）关系表接口
 *
 * @author Gavin
 * @date 2021-04-13 17:05:17
 */
public interface IKmsTenantryDirectCustomerOrgService extends IService<KmsTenantryDirectCustomerOrgEntity> {

    /**
     * 列表
     *
     * @param kmsTenantryDirectCustomerOrgReqVo
     * @return PageResult<KmsTenantryDirectCustomerOrgRespVo>
     */
    PageResult<KmsTenantryDirectCustomerOrgRespVo> findList(KmsTenantryDirectCustomerOrgReqVo kmsTenantryDirectCustomerOrgReqVo);

    /**
     * 查询
     *
     * @param id
     * @return KmsTenantryDirectCustomerOrgRespVo
     */
    KmsTenantryDirectCustomerOrgRespVo query(String id);

    /**
     * 新增
     *
     * @param kmsTenantryDirectCustomerOrgReqVo
     * @return
     */
    void save(KmsTenantryDirectCustomerOrgReqVo kmsTenantryDirectCustomerOrgReqVo);

    /**
     * 更新
     *
     * @param kmsTenantryDirectCustomerOrgReqVo
     * @return
     */
    void update(KmsTenantryDirectCustomerOrgReqVo kmsTenantryDirectCustomerOrgReqVo);

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     *
     * @param ids
     * @return
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     *
     * @param ids
     * @return
     */
    void disableBatch(List<String> ids);

    /**
     * 新增直营体系 获取客户组织下拉框
     *
     * @return
     */
    List<MdmCustomerOrgSelectRespVo> findCusOrgList(CusOrgVo cusOrgVo);
}

