package com.biz.crm.vo;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

/**
 * 分页远程请求VO封装
 * {@link T 请求参数类型}
 * {@link F 响应对象类型}
 * @author wangyihuai
 * @date 2019/09/02
 */
@ApiModel("分页远程请求VO封装")
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class RemotePageReqVo<T,F>  {

    /**
     * 租户ID（公参）
     */
    @ApiModelProperty("租户ID")
    private String tenantryId;

    /**
     * 参数对象
     */
    @ApiModelProperty("请求参数")
    private T reqVo;
    /**
     * 分页对象
     */
    @ApiModelProperty("封装分页信息")
    private Page<F> page;

    public RemotePageReqVo(T reqVo, Page<F> page) {
        this.reqVo = reqVo;
        this.page = page;
    }
}
