package com.biz.crm.webservice.order.req;

import com.biz.crm.nebular.kms.orderform.resp.KmsOrderFormRespVo;
import lombok.Builder;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

/**
 * @Project dmp-platform
 * @PackageName cn.linglong.dmp.common.vo.webservice.data
 * @ClassName QueryNoCompensation
 * @Author Gavin
 * @Date 2020/6/29 6:57 下午
 * @Description 查询码冻结
 */
@XmlRootElement
public class KmsZsdSalesorderDataRfcVo {
    /**
     * 订单头
     */
    @XmlElement(name = "IT_ZSSD00010")
    private KmsSapOrderHeaderVo orderHeader = new KmsSapOrderHeaderVo();

    @XmlElement(name = "I_MONI")
    private String iMoni = "";

    @XmlElement(name = "ET_BAPIRETURN1")
    private KmsSapEtBapiReturnVo returnVo = new KmsSapEtBapiReturnVo();

    @XmlElement(name = "IT_ZSSD00011")
    private KmsSapOrderItmeVo itmeVo = new KmsSapOrderItmeVo();

    @XmlTransient
    public KmsSapOrderHeaderVo getOrderHeader() {
        return orderHeader;
    }

    public void setOrderHeader(KmsSapOrderHeaderVo orderHeader) {
        this.orderHeader = orderHeader;
    }

    @XmlTransient
    public String getiMoni() {
        return iMoni;
    }

    public void setiMoni(String iMoni) {
        this.iMoni = iMoni;
    }

    @XmlTransient
    public KmsSapOrderItmeVo getItmeVo() {
        return itmeVo;
    }

    public void setItmeVo(KmsSapOrderItmeVo itmeVo) {
        this.itmeVo = itmeVo;
    }

    public KmsZsdSalesorderDataRfcVo(){
        super();
    }

    @Builder
    public KmsZsdSalesorderDataRfcVo(KmsOrderFormRespVo kmsOrderFormRespVo){
        this.iMoni = "";
        this.returnVo = new KmsSapEtBapiReturnVo();
        this.orderHeader = KmsSapOrderHeaderVo.builder().header(kmsOrderFormRespVo).build();
        this.itmeVo = KmsSapOrderItmeVo.builder().kmsOrderFormRespVo(kmsOrderFormRespVo).build();
    }
}