package com.biz.crm.acceptanceform.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.acceptanceform.model.KmsAcceptanceFormEntity;
import com.biz.crm.acceptanceform.model.KmsAcceptanceStatusRecordEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.kms.acceptanceform.req.KmsAcceptanceStatusRecordReqVo;
import com.biz.crm.nebular.kms.acceptanceform.resp.KmsAcceptanceStatusRecordRespVo;

import java.util.List;

/**
 * 验收单状态流转表接口
 *
 * @author Gavin
 * @date 2021-05-12 18:03:22
 */
public interface IKmsAcceptanceStatusRecordService extends IService<KmsAcceptanceStatusRecordEntity> {

    /**
     * 列表
     * @param kmsAcceptanceStatusRecordReqVo
     * @return PageResult<KmsAcceptanceStatusRecordRespVo>
     */
    PageResult<KmsAcceptanceStatusRecordRespVo> findList(KmsAcceptanceStatusRecordReqVo kmsAcceptanceStatusRecordReqVo);

    /**
     * 查询
     * @param kmsAcceptanceStatusRecordReqVo
     * @return KmsAcceptanceStatusRecordRespVo
     */
    KmsAcceptanceStatusRecordRespVo query(KmsAcceptanceStatusRecordReqVo kmsAcceptanceStatusRecordReqVo);

    /**
     * 新增
     * @param kmsAcceptanceStatusRecordReqVo
     * @return
     */
    void save(KmsAcceptanceStatusRecordReqVo kmsAcceptanceStatusRecordReqVo);

    /**
     * 更新
     * @param kmsAcceptanceStatusRecordReqVo
     * @return
     */
    void update(KmsAcceptanceStatusRecordReqVo kmsAcceptanceStatusRecordReqVo);

    /**
     * 删除
     * @param kmsAcceptanceStatusRecordReqVo
     * @return
     */
    void deleteBatch(KmsAcceptanceStatusRecordReqVo kmsAcceptanceStatusRecordReqVo);

    /**
     * 启用
     * @param kmsAcceptanceStatusRecordReqVo
     * @return
     */
    void enableBatch(KmsAcceptanceStatusRecordReqVo kmsAcceptanceStatusRecordReqVo);

    /**
     * 禁用
     * @param kmsAcceptanceStatusRecordReqVo
     * @return
     */
    void disableBatch(KmsAcceptanceStatusRecordReqVo kmsAcceptanceStatusRecordReqVo);

    /**
     * 保存验收单状态记录表
     * @param acceptanceFormEntities
     */
    void insert(List<KmsAcceptanceFormEntity> acceptanceFormEntities);

    /**
     * 保存验收单状态记录表
     * @param acceptanceFormEntities
     */
    void insert(KmsAcceptanceFormEntity acceptanceFormEntities);
}

