package com.biz.crm.acceptanceform.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.acceptanceform.mapper.KmsAcceptanceGoodsMapper;
import com.biz.crm.acceptanceform.model.KmsAcceptanceGoodsEntity;
import com.biz.crm.acceptanceform.service.IKmsAcceptanceGoodsService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.kms.acceptanceform.req.KmsAcceptanceGoodsReqVo;
import com.biz.crm.nebular.kms.acceptanceform.resp.KmsAcceptanceGoodsRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 验收单原始单据详情接口实现
 *
 * @author Gavin
 * @date 2021-05-12 18:03:22
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="KmsAcceptanceGoodsServiceExpandImpl")
public class KmsAcceptanceGoodsServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<KmsAcceptanceGoodsMapper, KmsAcceptanceGoodsEntity> implements IKmsAcceptanceGoodsService {

    @Resource
    private KmsAcceptanceGoodsMapper kmsAcceptanceGoodsMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<KmsAcceptanceGoodsRespVo> findList(KmsAcceptanceGoodsReqVo reqVo){
        Page<KmsAcceptanceGoodsRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<KmsAcceptanceGoodsRespVo> list = kmsAcceptanceGoodsMapper.findList(page, reqVo);
        return PageResult.<KmsAcceptanceGoodsRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return kmsAcceptanceGoodsRespVo
     */
    @Override
    public KmsAcceptanceGoodsRespVo query(KmsAcceptanceGoodsReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(KmsAcceptanceGoodsReqVo reqVo){
        KmsAcceptanceGoodsEntity entity = CrmBeanUtil.copy(reqVo,KmsAcceptanceGoodsEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(KmsAcceptanceGoodsReqVo reqVo){
        KmsAcceptanceGoodsEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(KmsAcceptanceGoodsReqVo reqVo){
        List<KmsAcceptanceGoodsEntity> kmsAcceptanceGoodsEntities = kmsAcceptanceGoodsMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsAcceptanceGoodsEntities)){
            kmsAcceptanceGoodsEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(kmsAcceptanceGoodsEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(KmsAcceptanceGoodsReqVo reqVo){
        //设置状态为启用
        List<KmsAcceptanceGoodsEntity> kmsAcceptanceGoodsEntities = kmsAcceptanceGoodsMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsAcceptanceGoodsEntities)){
            kmsAcceptanceGoodsEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(kmsAcceptanceGoodsEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(KmsAcceptanceGoodsReqVo reqVo){
        //设置状态为禁用
        List<KmsAcceptanceGoodsEntity> kmsAcceptanceGoodsEntities = kmsAcceptanceGoodsMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsAcceptanceGoodsEntities)){
                kmsAcceptanceGoodsEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(kmsAcceptanceGoodsEntities);
    }
}
