package com.biz.crm.confadmin.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.confadmin.model.KmsInterfaceParamEntity;
import com.biz.crm.nebular.kms.confadmin.req.BsGrabInterfaceParamReqVo;
import com.biz.crm.nebular.kms.confadmin.req.KmsInterfaceParamReqVo;
import com.biz.crm.nebular.kms.confadmin.resp.BsGrabInterfaceParamRespVo;
import com.biz.crm.nebular.kms.confadmin.resp.KmsInterfaceParamRespVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * kms抓单接口参数
 * 
 * @author Gavin
 * @date 2021-05-07 10:20:19
 */
public interface KmsInterfaceParamMapper extends BaseMapper<KmsInterfaceParamEntity> {
    /**
     * 列表
     * @param page
     * @param kmsInterfaceParamReqVo
     * @return
     */
    List<KmsInterfaceParamRespVo> findList(Page<KmsInterfaceParamRespVo> page, @Param("vo") KmsInterfaceParamReqVo kmsInterfaceParamReqVo);

    /**
     * 查询抓单参数
     * @param params
     * @return
     */
    List<BsGrabInterfaceParamRespVo> findGrabOrderParams(@Param("vo") BsGrabInterfaceParamReqVo params);
}
