package com.biz.crm.confadmin.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.confadmin.model.KmsDirectStoreAreaEntity;
import com.biz.crm.nebular.kms.confadmin.req.KmsDirectStoreAreaReqVo;
import com.biz.crm.nebular.kms.confadmin.resp.KmsDirectStoreAreaRespVo;

import java.util.List;

/**
 * 商超门店区域管理接口
 *
 * @author Gavin
 * @date 2021-05-06 14:48:12
 */
public interface IKmsDirectStoreAreaService extends IService<KmsDirectStoreAreaEntity> {

    /**
     * 列表
     *
     * @param kmsDirectStoreAreaReqVo
     * @return PageResult<KmsDirectStoreAreaRespVo>
     */
    PageResult<KmsDirectStoreAreaRespVo> findList(KmsDirectStoreAreaReqVo kmsDirectStoreAreaReqVo);

    /**
     * 查询
     *
     * @param id
     * @return KmsDirectStoreAreaRespVo
     */
    KmsDirectStoreAreaRespVo query(String id);

    /**
     * 新增
     *
     * @param kmsDirectStoreAreaReqVo
     * @return
     */
    void save(KmsDirectStoreAreaReqVo kmsDirectStoreAreaReqVo);

    /**
     * 更新
     *
     * @param kmsDirectStoreAreaReqVo
     * @return
     */
    void update(KmsDirectStoreAreaReqVo kmsDirectStoreAreaReqVo);

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     *
     * @param ids
     * @return
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     *
     * @param ids
     * @return
     */
    void disableBatch(List<String> ids);
}

