package com.biz.crm.confadmin.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.confadmin.model.KmsDirectStoreEntity;
import com.biz.crm.nebular.kms.confadmin.req.KmsDirectStoreReqVo;
import com.biz.crm.nebular.kms.confadmin.resp.KmsDirectStoreRespVo;

import java.util.List;

/**
 * 商超门店管理接口
 *
 * @author Gavin
 * @date 2021-05-06 14:03:40
 */
public interface IKmsDirectStoreService extends IService<KmsDirectStoreEntity> {

    /**
     * 列表
     *
     * @param kmsDirectStoreReqVo
     * @return PageResult<KmsDirectStoreRespVo>
     */
    PageResult<KmsDirectStoreRespVo> findList(KmsDirectStoreReqVo kmsDirectStoreReqVo);

    /**
     * 查询
     *
     * @param id
     * @return KmsDirectStoreRespVo
     */
    KmsDirectStoreRespVo query(String id);

    /**
     * 新增
     *
     * @param kmsDirectStoreReqVo
     * @return
     */
    void save(KmsDirectStoreReqVo kmsDirectStoreReqVo);

    /**
     * 更新
     *
     * @param kmsDirectStoreReqVo
     * @return
     */
    void update(KmsDirectStoreReqVo kmsDirectStoreReqVo);

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     *
     * @param ids
     * @return
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     *
     * @param ids
     * @return
     */
    void disableBatch(List<String> ids);
}

