package com.biz.crm.constant;

import java.math.BigDecimal;

/**
 * @Project crm
 * @PackageName com.biz.crm.constant
 * @ClassName KmsConstant
 * @Author Gavin
 * @Date 2021/5/6 下午2:22
 * @Description 固定值
 */
public class KmsConstant {

    /**
     * 防止条件缺失匹配到错误单据
     */
    public static final String ORDER_NUMBER = "NULLORDER";

    /**
     * 税率换算
     */
    public static final BigDecimal BASE_1000 = new BigDecimal(1000);

    /**
     * 订单推送SAP发货日期 数据字典编码kms_order_shipping_date
     */
    public static final String KMS_ORDER_SHIPPING_DATE = "kms_order_shipping_date";

    /**
     * 星期物料推送SAP转换时间阈值
     */
    public static final String KMS_ORDER_WEEK_PRODUCT_DATE = "kms_order_week_product_date";

    /**
     * 抓取SAP分布式锁-lock
     */
    public static final String PULL_SAP_LOCK_KEY = "PULL_SAP_LOCK_KEY";

    /**
     * 手动批量匹配数据分布式锁-lock
     */
    public static final String MANUAL_BSTCH_MATCH_LOCK_KEY = "MANUAL_BSTCH_MATCH_LOCK_KEY";

    /**
     * 手动转换单据-lock
     */
    public static final String MANUAL_TRANS_FORM = "MANUAL_TRANS_FORM";

    /**
     * 推送单据到SAP——lock
     */
    public static final String PUSH_ORDER_FORM_TO_SAP = "PUSH_ORDER_FORM_TO_SAP";

    /**
     * sap数据列
     */
    public static final String SAP_COLUMNS = "t.fkdat,t.erzet,t.fkart,t.fkartvtext,t.vbeln,t.posnr,t.pstyv,t.vtext,t.vgbel,t.vgpos,t.aubel,t.aupos,t.bukrs,t.matnr,t.maktx,t.mtpos,t.fkimg,t.fkimgzp,t.vrkme,t.vrkmename,t.fkimg1,t.fkimgzp1,t.kmein,t.kmeinname,t.netwr,t.mwsbp,t.kzwi1,t.mwsi1,t.kzwi4,t.yk99,t.kunnr,t.kunnrname,t.kunag,t.kunagname,t.vrkmetype,t.guige,t.vtweg,t.vbakerdat,t.lifnr,t.name3,t.bstkd,t.danjia,t.yk04,t.yk11,t.zst2,t.pernr,t.name4";

}