package com.biz.crm.finance.helper;

import com.biz.crm.eunm.kms.KmsAdminEnum;
import com.biz.crm.eunm.kms.KmsEnum;
import com.biz.crm.finance.model.KmsAuditTemplateDirectEntity;
import com.biz.crm.nebular.kms.finance.req.KmsAuditTemplateDirectReqVo;
import com.biz.crm.nebular.kms.finance.req.KmsAuditTemplateReqVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @Project crm
 * @PackageName com.biz.crm.finance.helper
 * @ClassName KmsAuditTemplateHelper
 * @Author Gavin
 * @Date 2021/5/26 上午10:57
 * @Description 稽核模版助手
 */
@Slf4j
@Component
public class KmsAuditTemplateHelper {

    /**
     * 参数校验
     * @param reqVo
     */
    public void check(KmsAuditTemplateReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getTemplateName(),"模版名称不能为空");
        AssertUtils.isNotEmpty(reqVo.getOrderTypeList(),"单据类型集合不能为空");
        AssertUtils.isNotEmpty(reqVo.getConditionList(),"匹配条件集合不能为空");
        AssertUtils.isNotEmpty(reqVo.getDirectVos(),"商超对象信息不能为空");
        reqVo.getOrderTypeList().forEach(o -> {
            String s = KmsAdminEnum.OrderType.GETMAP.get(o);
            AssertUtils.isNotEmpty(s,"单据类型错误");
        });
        reqVo.setOrderTypeArray(reqVo.getOrderTypeList().stream().sorted().collect(Collectors.joining(",")));
        reqVo.getConditionList().forEach(o -> {
            String s = KmsAdminEnum.AuditCondition.GETMAP.get(o);
            AssertUtils.isNotEmpty(s,"稽核条件错误");
        });
        reqVo.setConditionArray(reqVo.getConditionList().stream().sorted().collect(Collectors.joining(",")));
        reqVo.getDirectVos().forEach(o -> {
            AssertUtils.isNotEmpty(o.getDirectId(),"商超ID不能为空");
            AssertUtils.isNotEmpty(o.getDirectName(),"商超名称不能为空");
            AssertUtils.isNotNull(o.getDifferencePrice(),"价格允差不能为空");
            AssertUtils.isNotEmpty(o.getAuditRule(),"容差规则不能为空");
            String s = KmsEnum.AuditRule.GETMAP.get(o.getAuditRule());
            AssertUtils.isNotEmpty(s,"容差规则数据错误");
        });
    }

    /**
     * 构建规则商超信息
     * @param reqVo
     * @return
     */
    public List<KmsAuditTemplateDirectEntity> buildAuditDirect(KmsAuditTemplateReqVo reqVo) {
        List<KmsAuditTemplateDirectReqVo> directVos = reqVo.getDirectVos();
        directVos.forEach(o -> {
            o.setAuditTemplateId(reqVo.getId());
        });
        return CrmBeanUtil.copyList(directVos,KmsAuditTemplateDirectEntity.class);
    }
}